/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.BaseComponentAdapter;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.ServiceComponentAdapterKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ-\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00140\tH\u0002\u00a2\u0006\u0002\u0010\u0015J7\u0010\u0016\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00140\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/serviceContainer/ServiceComponentAdapter;", "Lcom/intellij/serviceContainer/BaseComponentAdapter;", "descriptor", "Lcom/intellij/openapi/components/ServiceDescriptor;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "implementationClass", "Ljava/lang/Class;", "initializedInstance", "", "(Lcom/intellij/openapi/components/ServiceDescriptor;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/serviceContainer/ComponentManagerImpl;Ljava/lang/Class;Ljava/lang/Object;)V", "getDescriptor", "()Lcom/intellij/openapi/components/ServiceDescriptor;", "implementationClassName", "", "getImplementationClassName", "()Ljava/lang/String;", "createAndInitialize", "T", "(Lcom/intellij/serviceContainer/ComponentManagerImpl;Ljava/lang/Class;)Ljava/lang/Object;", "doCreateInstance", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/serviceContainer/ComponentManagerImpl;Ljava/lang/Class;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "getActivityCategory", "Lcom/intellij/diagnostic/ActivityCategory;", "getComponentKey", "isImplementationEqualsToInterface", "", "toString", "intellij.platform.serviceContainer"})
public final class ServiceComponentAdapter
extends BaseComponentAdapter {
    @NotNull
    private final ServiceDescriptor descriptor;

    @Override
    @NotNull
    protected String getImplementationClassName() {
        String string = this.descriptor.getImplementation();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    protected boolean isImplementationEqualsToInterface() {
        return this.descriptor.serviceInterface == null || Intrinsics.areEqual((Object)this.descriptor.serviceInterface, (Object)this.descriptor.getImplementation());
    }

    @NotNull
    public String getComponentKey() {
        String string = this.descriptor.getInterface();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.getInterface()");
        return string;
    }

    @Override
    @NotNull
    protected ActivityCategory getActivityCategory(@NotNull ComponentManagerImpl componentManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        return ServiceComponentAdapterKt.getServiceActivityCategory(componentManager);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <T> T doCreateInstance(@NotNull ComponentManagerImpl componentManager, @NotNull Class<T> implementationClass, @Nullable ProgressIndicator indicator) {
        void instance;
        Application app;
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        Intrinsics.checkParameterIsNotNull(implementationClass, (String)"implementationClass");
        if (ComponentManagerImplKt.getLOG().isDebugEnabled() && (app = componentManager.getApplication$intellij_platform_serviceContainer()) != null && app.isWriteAccessAllowed() && !app.isUnitTestMode() && PersistentStateComponent.class.isAssignableFrom(implementationClass)) {
            ComponentManagerImplKt.getLOG().warn(new Throwable("Getting service from write-action leads to possible deadlock. Service implementation " + this.getImplementationClassName()));
        }
        if (indicator == null) {
            return this.createAndInitialize(componentManager, implementationClass);
        }
        app = new Ref.ObjectRef();
        app.element = null;
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(this, (Ref.ObjectRef)instance, componentManager, implementationClass){
            final /* synthetic */ ServiceComponentAdapter this$0;
            final /* synthetic */ Ref.ObjectRef $instance;
            final /* synthetic */ ComponentManagerImpl $componentManager;
            final /* synthetic */ Class $implementationClass;

            public final void run() {
                this.$instance.element = ServiceComponentAdapter.access$createAndInitialize(this.this$0, this.$componentManager, this.$implementationClass);
            }
            {
                this.this$0 = serviceComponentAdapter;
                this.$instance = objectRef;
                this.$componentManager = componentManagerImpl;
                this.$implementationClass = clazz;
            }
        });
        Object object = instance.element;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (T)object;
    }

    private final <T> T createAndInitialize(ComponentManagerImpl componentManager, Class<T> implementationClass) {
        T instance = componentManager.instantiateClassWithConstructorInjection(implementationClass, this.getComponentKey(), this.getPluginId());
        if (instance instanceof Disposable) {
            Disposer.register((Disposable)componentManager.getServiceParentDisposable$intellij_platform_serviceContainer(), (Disposable)((Disposable)instance));
        }
        componentManager.initializeComponent$intellij_platform_serviceContainer(instance, this.descriptor, this.getPluginId());
        return instance;
    }

    @NotNull
    public String toString() {
        return "ServiceAdapter(descriptor=" + this.descriptor + ", pluginDescriptor=" + this.getPluginDescriptor() + ')';
    }

    @NotNull
    public final ServiceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ServiceComponentAdapter(@NotNull ServiceDescriptor descriptor, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManagerImpl componentManager, @Nullable Class<?> implementationClass, @Nullable Object initializedInstance) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        super(componentManager, pluginDescriptor, initializedInstance, implementationClass);
        this.descriptor = descriptor;
    }

    public /* synthetic */ ServiceComponentAdapter(ServiceDescriptor serviceDescriptor, PluginDescriptor pluginDescriptor, ComponentManagerImpl componentManagerImpl, Class clazz, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clazz = null;
        }
        if ((n & 0x10) != 0) {
            object = null;
        }
        this(serviceDescriptor, pluginDescriptor, componentManagerImpl, clazz, object);
    }

    public static final /* synthetic */ Object access$createAndInitialize(ServiceComponentAdapter $this, ComponentManagerImpl componentManager, Class implementationClass) {
        return $this.createAndInitialize(componentManager, implementationClass);
    }
}

