/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.stash.GitChangesSaver;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitShelveChangesSaver
extends GitChangesSaver {
    private final VcsShelveChangesSaver myVcsShelveChangesSaver;
    private final ShelvedChangesViewManager myShelveViewManager;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull String stashMessage) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(3);
        }
        super(project, git, indicator, GitSaveChangesPolicy.SHELVE, stashMessage);
        this.myShelveViewManager = ShelvedChangesViewManager.getInstance((Project)this.myProject);
        this.myVcsShelveChangesSaver = new VcsShelveChangesSaver(project, indicator, stashMessage){

            protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave) {
                if (rootsToSave == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VirtualFile virtualFile : rootsToSave) {
                    GitRollbackEnvironment.resetHardLocal(GitShelveChangesSaver.this.myProject, virtualFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToSave", "git4idea/stash/GitShelveChangesSaver$1", "doRollback"));
            }
        };
    }

    @Override
    protected void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(4);
        }
        this.myVcsShelveChangesSaver.save(rootsToSave);
    }

    @Override
    public void load() {
        this.myVcsShelveChangesSaver.load();
    }

    @Override
    public boolean wereChangesSaved() {
        return this.myVcsShelveChangesSaver.getShelvedLists() != null && !this.myVcsShelveChangesSaver.getShelvedLists().isEmpty();
    }

    @Override
    public void showSavedChanges() {
        if (this.myVcsShelveChangesSaver.getShelvedLists() == null) {
            return;
        }
        this.myShelveViewManager.activateView((ShelvedChangeList)this.myVcsShelveChangesSaver.getShelvedLists().get(this.myVcsShelveChangesSaver.getShelvedLists().keySet().iterator().next()));
    }

    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myVcsShelveChangesSaver.getShelvedLists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
        }
        objectArray2[1] = "git4idea/stash/GitShelveChangesSaver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

