/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCompareBranchesUi;
import git4idea.branch.ShowDiffWithBranchDialog;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;

    GitBrancherImpl(@NotNull Project project) {
        if (project == null) {
            GitBrancherImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(1);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(2);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$1", "execute"));
            }
        }.runInBackground();
    }

    @NotNull
    private GitBranchWorker newWorker(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GitBrancherImpl.$$$reportNull$$$0(3);
        }
        return new GitBranchWorker(this.myProject, Git.getInstance(), new GitBranchUiHandlerImpl(this.myProject, Git.getInstance(), indicator));
    }

    @Override
    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(4);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(5);
        }
        this.createBranch(name, startPoints, false);
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints, final boolean force) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(6);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(7);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.creating.branch.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints, force);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$2", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(8);
        }
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(9);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(10);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$3", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(11);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(12);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.process", reference), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$4", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(13);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(14);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(15);
        }
        this.checkoutNewBranchStartingFrom(newBranchName, startPoint, false, repositories, callInAwtLater);
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final boolean overwriteIfNeeded, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(16);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(17);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(18);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.branch.from.process", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, overwriteIfNeeded, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$5", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(19);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(20);
        }
        this.deleteBranches(Collections.singletonMap(branchName, repositories), null);
    }

    @Override
    public void deleteBranches(final @NotNull Map<String, List<? extends GitRepository>> branchesToContainingRepositories, @Nullable Runnable callInAwtAfterExecution) {
        if (branchesToContainingRepositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(21);
        }
        if (branchesToContainingRepositories.isEmpty()) {
            return;
        }
        final Set<String> branchNames = branchesToContainingRepositories.keySet();
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.branch.process", branchMsg), callInAwtAfterExecution){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                GitBranchWorker worker = GitBrancherImpl.this.newWorker(indicator);
                for (String branchName : branchNames) {
                    worker.deleteBranch(branchName, branchesToContainingRepositories.getOrDefault(branchName, Collections.emptyList()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$6", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(22);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(23);
        }
        this.deleteRemoteBranches(Collections.singletonList(branchName), repositories);
    }

    @Override
    public void deleteRemoteBranches(final @NotNull List<String> branchNames, final @NotNull List<? extends GitRepository> repositories) {
        if (branchNames == null) {
            GitBrancherImpl.$$$reportNull$$$0(24);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(25);
        }
        if (branchNames.isEmpty()) {
            return;
        }
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.remote.branch", branchMsg), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranches(branchNames, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$7", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void compare(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(26);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(27);
        }
        new GitCompareBranchesUi(this.myProject, repositories, branchName).create();
    }

    @Override
    public void compareAny(@NotNull String branchName, @NotNull String otherBranchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(28);
        }
        if (otherBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(29);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(30);
        }
        new GitCompareBranchesUi(this.myProject, repositories, branchName, otherBranchName).create();
    }

    @Override
    public void showDiffWithLocal(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(31);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(32);
        }
        new ShowDiffWithBranchDialog(this.myProject, branchName, repositories, GitBranchUtil.getCurrentBranchOrRev(repositories)).show();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<? extends GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(33);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(34);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(35);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.merging.process", branchName), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$8", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(36);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(37);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.onto.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    9.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$9", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(@NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(38);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(39);
        }
        this.rebase(repositories, "HEAD", branchName);
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories, final @NotNull String upstream, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(40);
        }
        if (upstream == null) {
            GitBrancherImpl.$$$reportNull$$$0(41);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(42);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    10.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, upstream, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$10", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<? extends GitRepository> repositories) {
        if (currentName == null) {
            GitBrancherImpl.$$$reportNull$$$0(43);
        }
        if (newName == null) {
            GitBrancherImpl.$$$reportNull$$$0(44);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(45);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.renaming.branch.process", currentName, newName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    11.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$11", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteTag(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(46);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(47);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    12.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteTag(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$12", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteTag(final @NotNull String name, final @NotNull Map<GitRepository, String> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(48);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(49);
        }
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.on.remote.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    13.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteTag(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$13", "execute"));
            }
        }.runInBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 19: 
            case 22: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesToContainingRepositories";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranchName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstream";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "git4idea/branch/GitBrancherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "newWorker";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createBranch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewTag";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkout";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBranch";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBranches";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteBranch";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteBranches";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAny";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiffWithLocal";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "rebase";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "rebaseOnCurrent";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "renameBranch";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteTag";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @Nls @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            if (title == null) {
                CommonBackgroundTask.$$$reportNull$$$0(0);
            }
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CommonBackgroundTask.$$$reportNull$$$0(1);
            }
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                application.invokeAndWait(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/branch/GitBrancherImpl$CommonBackgroundTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

