/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingColors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.awt.Color;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class XmlTagTreeHighlightingUtil {
    private XmlTagTreeHighlightingUtil() {
    }

    static boolean containsTagsWithSameName(PsiElement[] elements) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            String name;
            if (!(element instanceof XmlTag) || names.add(name = ((XmlTag)element).getName())) continue;
            return true;
        }
        return false;
    }

    static boolean isTagTreeHighlightingActive(PsiFile file) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!XmlTagTreeHighlightingUtil.hasXmlViewProvider(file) && !HtmlUtil.supportsXmlTypedHandlers(file)) {
            return false;
        }
        return WebEditorOptions.getInstance().isTagTreeHighlightingEnabled();
    }

    private static boolean hasXmlViewProvider(@NotNull PsiFile file) {
        if (file == null) {
            XmlTagTreeHighlightingUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile f : file.getViewProvider().getAllFiles()) {
            if (!(f instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    static Color[] getBaseColors() {
        ColorKey[] colorKeys = XmlTagTreeHighlightingColors.getColorKeys();
        Color[] colors = new Color[colorKeys.length];
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorsScheme.getColor(colorKeys[i]);
        }
        return colors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil", "hasXmlViewProvider"));
    }
}

