/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.DxfViewer;
import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Graphics;

public class DrawSet
extends DrawAble {
    Matrix4D trafo;
    DrawAble[] drawables;
    int nrDrawables;

    public DrawSet(Matrix4D mat, int nr) {
        this.trafo = mat;
        if (nr > 0) {
            this.drawables = new DrawAble[nr];
        }
    }

    public DrawSet() {
    }

    public DrawSet(Matrix4D mat) {
        this.trafo = mat;
    }

    public DrawSet(int nr) {
        if (nr > 0) {
            this.drawables = new DrawAble[nr];
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colors, short insColor) {
        Matrix4D tmat = this.calculateTrafo(mat);
        DxfLAYER myLayer = this.getCorrectLayer(insLayer);
        short myColor = this.calcColor(insColor, insLayer);
        int i = 0;
        while (i < this.nrDrawables) {
            this.drawables[i].draw(g, tmat, myLayer, colors, myColor);
            ++i;
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor, LineStyleManager lineStyles, LineStyle insLStyle) {
        Matrix4D tmat = this.calculateTrafo(mat);
        DxfLAYER myLayer = this.getCorrectLayer(insLayer);
        short myColor = this.calcColor(insColor, insLayer);
        LineStyle myLStyle = lineStyles.getLineStyle(this.lineType, insLStyle, myLayer);
        int i = 0;
        while (i < this.nrDrawables) {
            this.drawables[i].draw(g, tmat, myLayer, colorModel, myColor, lineStyles, myLStyle);
            ++i;
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colors, short insColor, int nr, int maxNr) {
        Matrix4D tmat = this.calculateTrafo(mat);
        DxfLAYER myLayer = this.getCorrectLayer(insLayer);
        short myColor = this.color != -1 ? this.color : insColor;
        int i = 0;
        while (i < this.nrDrawables) {
            this.drawables[i].draw(g, tmat, myLayer, colors, myColor, nr, maxNr);
            if (--nr < 0) {
                nr = maxNr;
            }
            ++i;
        }
    }

    private Matrix4D calculateTrafo(Matrix4D mat) {
        Matrix4D tmat;
        if (this.trafo == null) {
            tmat = mat;
        } else {
            tmat = new Matrix4D(this.trafo);
            if (mat != null) {
                tmat.multLeftBy(mat);
            }
        }
        return tmat;
    }

    public void addDrawable(DrawAble d) {
        if (d == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new DrawAble[4];
        } else if (this.nrDrawables == this.drawables.length) {
            DrawAble[] newd = new DrawAble[2 * this.drawables.length];
            System.arraycopy(this.drawables, 0, newd, 0, this.drawables.length);
            this.drawables = newd;
        }
        this.drawables[this.nrDrawables++] = d;
    }

    public void setTrafo(Matrix4D mat) {
        this.trafo = mat;
    }

    public int calcBB(Point3D min, Point3D max, Matrix4D mat, DxfLAYER insertLayer, boolean onlyVisible) {
        if (onlyVisible && !this.isVisible(insertLayer)) {
            return 0;
        }
        int nrLines = 0;
        Matrix4D tmp = mat == null ? this.trafo : (this.trafo == null ? mat : mat.mult(this.trafo));
        int i = 0;
        while (i < this.nrDrawables) {
            nrLines += this.drawables[i].calcBB(min, max, tmp, this.layer == null || this.layer.isLayer0() ? insertLayer : this.layer, onlyVisible);
            ++i;
        }
        return nrLines;
    }

    public void transformBy(Matrix4D mat) {
        if (this.trafo != null) {
            this.trafo.multLeftBy(mat);
        } else {
            this.trafo = mat;
        }
    }

    public DrawAble extrude(float dist, Vector3D up) {
        if (this.trafo == null) {
            int d = this.drawables.length - 1;
            while (d >= 0) {
                this.drawables[d] = this.drawables[d].extrude(dist, up);
                --d;
            }
        } else if (DxfViewer.debugLevel > 0) {
            System.err.println("Cannot extrude complex DrawSet...");
        }
        return this;
    }
}

