function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo, useCallback } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiFlexGroup, EuiFlexItem, EuiSpacer } from '@elastic/eui';
import { ChartTypes } from '../../../utils/collections';
import { SelectOption } from '../../../../../charts/public';
import { LineOptions } from './line_options';

function ChartOptions(_ref) {
  var chart = _ref.chart,
      index = _ref.index,
      valueAxes = _ref.valueAxes,
      vis = _ref.vis,
      changeValueAxis = _ref.changeValueAxis,
      setParamByIndex = _ref.setParamByIndex;
  var setChart = useCallback(function (paramName, value) {
    setParamByIndex('seriesParams', index, paramName, value);
  }, [setParamByIndex, index]);
  var setValueAxis = useCallback(function (paramName, value) {
    changeValueAxis(index, paramName, value);
  }, [changeValueAxis, index]);
  var valueAxesOptions = useMemo(function () {
    return [].concat(_toConsumableArray(valueAxes.map(function (_ref2) {
      var id = _ref2.id,
          name = _ref2.name;
      return {
        text: name,
        value: id
      };
    })), [{
      text: i18n.translate('visTypeVislib.controls.pointSeries.series.newAxisLabel', {
        defaultMessage: 'New axis…'
      }),
      value: 'new'
    }]);
  }, [valueAxes]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SelectOption, {
    id: "seriesValueAxis".concat(index),
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.valueAxisLabel', {
      defaultMessage: 'Value axis'
    }),
    options: valueAxesOptions,
    paramName: "valueAxis",
    value: chart.valueAxis,
    setValue: setValueAxis
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(SelectOption, {
    id: "seriesType".concat(index),
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.chartTypeLabel', {
      defaultMessage: 'Chart type'
    }),
    options: vis.type.editorConfig.collections.chartTypes,
    paramName: "type",
    value: chart.type,
    setValue: setChart
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(SelectOption, {
    id: "seriesMode".concat(index),
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.modeLabel', {
      defaultMessage: 'Mode'
    }),
    options: vis.type.editorConfig.collections.chartModes,
    paramName: "mode",
    value: chart.mode,
    setValue: setChart
  }))), chart.type === ChartTypes.AREA && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: vis.type.editorConfig.collections.interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart
  })), chart.type === ChartTypes.LINE && /*#__PURE__*/React.createElement(LineOptions, {
    chart: chart,
    vis: vis,
    setChart: setChart
  }));
}

export { ChartOptions };