function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useState } from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiButton, EuiButtonEmpty, EuiButtonToggle, EuiToolTip } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { useDebounce } from 'react-use';
import { discardChanges } from './state';

function DefaultEditorControls(_ref) {
  var applyChanges = _ref.applyChanges,
      isDirty = _ref.isDirty,
      isInvalid = _ref.isInvalid,
      isTouched = _ref.isTouched,
      dispatch = _ref.dispatch,
      vis = _ref.vis;
  var enableAutoApply = vis.type.editorConfig.enableAutoApply;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      autoApplyEnabled = _useState2[0],
      setAutoApplyEnabled = _useState2[1];

  var toggleAutoApply = useCallback(function (e) {
    return setAutoApplyEnabled(e.target.checked);
  }, []);
  var onClickDiscard = useCallback(function () {
    return dispatch(discardChanges(vis));
  }, [dispatch, vis]);
  useDebounce(function () {
    if (autoApplyEnabled && isDirty) {
      applyChanges();
    }
  }, 300, [isDirty, autoApplyEnabled, applyChanges]);
  return /*#__PURE__*/React.createElement("div", {
    className: "visEditorSidebar__controls"
  }, !autoApplyEnabled && /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "data-test-subj": "visualizeEditorResetButton",
    disabled: !isDirty,
    iconType: "cross",
    onClick: onClickDiscard,
    size: "s"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.discardChangesButtonLabel",
    defaultMessage: "Discard"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, isInvalid && isTouched ? /*#__PURE__*/React.createElement(EuiToolTip, {
    content: i18n.translate('visDefaultEditor.sidebar.errorButtonTooltip', {
      defaultMessage: 'Errors in the highlighted fields need to be resolved.'
    })
  }, /*#__PURE__*/React.createElement(EuiButton, {
    color: "danger",
    iconType: "alert",
    size: "s",
    disabled: true
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update"
  }))) : /*#__PURE__*/React.createElement(EuiButton, {
    "data-test-subj": "visualizeEditorRenderButton",
    disabled: !isDirty,
    fill: true,
    iconType: "play",
    onClick: applyChanges,
    size: "s"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update"
  })))), enableAutoApply && /*#__PURE__*/React.createElement(EuiToolTip, {
    title: autoApplyEnabled ? i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOnLabel', {
      defaultMessage: 'Auto apply is on'
    }) : i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOffLabel', {
      defaultMessage: 'Auto apply is off'
    }),
    content: i18n.translate('visDefaultEditor.sidebar.autoApplyChangesTooltip', {
      defaultMessage: 'Auto updates the visualization on every change.'
    })
  }, /*#__PURE__*/React.createElement(EuiButtonToggle, {
    label: i18n.translate('visDefaultEditor.sidebar.autoApplyChangesAriaLabel', {
      defaultMessage: 'Auto apply editor changes'
    }),
    className: "visEditorSidebar__autoApplyButton",
    "data-test-subj": "visualizeEditorAutoButton",
    fill: autoApplyEnabled,
    iconType: "refresh",
    isSelected: autoApplyEnabled,
    onChange: toggleAutoApply,
    size: "s",
    isIconOnly: true
  })));
}

export { DefaultEditorControls };