function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { SavedObjectNotFound } from '../../../../kibana_utils/public';
import { injectSearchSourceReferences, parseSearchSourceJSON, expandShorthand } from '../../../../data/public';
/**
 * A given response of and ElasticSearch containing a plain saved object is applied to the given
 * savedObject
 */

export function applyESResp(_x, _x2, _x3, _x4) {
  return _applyESResp.apply(this, arguments);
}

function _applyESResp() {
  _applyESResp = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(resp, savedObject, config, dependencies) {
    var mapping, esType, injectReferences, meta, searchSourceValues;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            mapping = expandShorthand(config.mapping);
            esType = config.type || '';
            savedObject._source = _.cloneDeep(resp._source);
            injectReferences = config.injectReferences;

            if (!(typeof resp.found === 'boolean' && !resp.found)) {
              _context.next = 6;
              break;
            }

            throw new SavedObjectNotFound(esType, savedObject.id || '');

          case 6:
            meta = resp._source.kibanaSavedObjectMeta || {};
            delete resp._source.kibanaSavedObjectMeta;

            if (!config.indexPattern && savedObject._source.indexPattern) {
              config.indexPattern = savedObject._source.indexPattern;
              delete savedObject._source.indexPattern;
            } // assign the defaults to the response


            _.defaults(savedObject._source, savedObject.defaults); // transform the source using _deserializers


            _.forOwn(mapping, function (fieldMapping, fieldName) {
              if (fieldMapping._deserialize && typeof fieldName === 'string') {
                savedObject._source[fieldName] = fieldMapping._deserialize(savedObject._source[fieldName]);
              }
            }); // Give obj all of the values in _source.fields


            _.assign(savedObject, savedObject._source);

            savedObject.lastSavedTitle = savedObject.title;

            if (!meta.searchSourceJSON) {
              _context.next = 30;
              break;
            }

            _context.prev = 14;
            searchSourceValues = parseSearchSourceJSON(meta.searchSourceJSON);

            if (!config.searchSource) {
              _context.next = 23;
              break;
            }

            searchSourceValues = injectSearchSourceReferences(searchSourceValues, resp.references);
            _context.next = 20;
            return dependencies.search.searchSource.create(searchSourceValues);

          case 20:
            savedObject.searchSource = _context.sent;
            _context.next = 24;
            break;

          case 23:
            savedObject.searchSourceFields = searchSourceValues;

          case 24:
            _context.next = 30;
            break;

          case 26:
            _context.prev = 26;
            _context.t0 = _context["catch"](14);

            if (_context.t0.constructor.name === 'SavedObjectNotFound' && _context.t0.savedObjectType === 'index-pattern') {
              // if parsing the search source fails because the index pattern wasn't found,
              // remember the reference - this is required for error handling on legacy imports
              savedObject.unresolvedIndexPatternReference = {
                name: 'kibanaSavedObjectMeta.searchSourceJSON.index',
                id: JSON.parse(meta.searchSourceJSON).index,
                type: 'index-pattern'
              };
            }

            throw _context.t0;

          case 30:
            if (injectReferences && resp.references && resp.references.length > 0) {
              injectReferences(savedObject, resp.references);
            }

            if (!(typeof config.afterESResp === 'function')) {
              _context.next = 35;
              break;
            }

            _context.next = 34;
            return config.afterESResp(savedObject);

          case 34:
            savedObject = _context.sent;

          case 35:
            return _context.abrupt("return", savedObject);

          case 36:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[14, 26]]);
  }));
  return _applyESResp.apply(this, arguments);
}