function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useState, useCallback, useRef } from 'react';
export function useMultiContent(_ref) {
  var defaultValue = _ref.defaultValue,
      onChange = _ref.onChange;

  /**
   * Each content validity is kept in this state. When updating a content with "updateContentAt()", we
   * update the state validity and trigger a re-render.
   */
  var _useState = useState({
    isValid: true,
    contents: {}
  }),
      _useState2 = _slicedToArray(_useState, 2),
      validation = _useState2[0],
      setValidation = _useState2[1];
  /**
   * The updated data where a content current data is merged when it unmounts
   */


  var _useState3 = useState(defaultValue !== null && defaultValue !== void 0 ? defaultValue : {}),
      _useState4 = _slicedToArray(_useState3, 2),
      stateData = _useState4[0],
      setStateData = _useState4[1];
  /**
   * A map object of all the active content(s) present in the DOM. In a multi step
   * form wizard, there is only 1 content at the time in the DOM, but in long vertical
   * flow content, multiple content could be present.
   * When a content unmounts it will remove itself from this map.
   */


  var contents = useRef({});
  var updateContentDataAt = useCallback(function (updatedData) {
    setStateData(function (prev) {
      return _objectSpread(_objectSpread({}, prev), updatedData);
    });
  }, []);
  /**
   * Read the multi content data.
   */

  var getData = useCallback(function () {
    /**
     * If there is one or more active content(s) in the DOM, and it is valid,
     * we read its data and merge it into our stateData before returning it.
     */
    var activeContentData = {};

    for (var _i2 = 0, _Object$entries = Object.entries(contents.current); _i2 < _Object$entries.length; _i2++) {
      var _Object$entries$_i = _slicedToArray(_Object$entries[_i2], 2),
          _id = _Object$entries$_i[0],
          _content = _Object$entries$_i[1];

      if (validation.contents[_id]) {
        (function () {
          var contentData = _content.getData(); // Replace the getData() handler with the cached value


          _content.getData = function () {
            return contentData;
          };

          activeContentData[_id] = contentData;
        })();
      }
    }

    return _objectSpread(_objectSpread({}, stateData), activeContentData);
  }, [stateData, validation]);
  var updateContentValidity = useCallback(function (updatedData) {
    var allContentValidity;
    setValidation(function (prev) {
      if (Object.entries(updatedData).every(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            contentId = _ref3[0],
            isValid = _ref3[1];

        return prev.contents[contentId] === isValid;
      })) {
        // No change in validation, nothing to update
        allContentValidity = prev.isValid;
        return prev;
      }

      var nextContentsValidityState = _objectSpread(_objectSpread({}, prev.contents), updatedData);

      allContentValidity = Object.values(nextContentsValidityState).some(function (_isValid) {
        return _isValid === undefined;
      }) ? undefined : Object.values(nextContentsValidityState).every(Boolean);
      return {
        isValid: allContentValidity,
        contents: nextContentsValidityState
      };
    });
    return allContentValidity;
  }, []);
  /**
   * Validate the multi-content active content(s) in the DOM
   */

  var validate = useCallback( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
    var updatedValidation, _loop, _i3, _Object$entries2;

    return regeneratorRuntime.wrap(function _callee2$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (!(Object.keys(contents.current).length === 0)) {
              _context3.next = 2;
              break;
            }

            return _context3.abrupt("return", Boolean(validation.isValid));

          case 2:
            updatedValidation = {};
            _loop = /*#__PURE__*/regeneratorRuntime.mark(function _loop() {
              var _Object$entries2$_i, id, _content, isValid;

              return regeneratorRuntime.wrap(function _loop$(_context2) {
                while (1) {
                  switch (_context2.prev = _context2.next) {
                    case 0:
                      _Object$entries2$_i = _slicedToArray(_Object$entries2[_i3], 2), id = _Object$entries2$_i[0], _content = _Object$entries2$_i[1];
                      _context2.next = 3;
                      return _content.validate();

                    case 3:
                      isValid = _context2.sent;
                      _content.validate = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                        return regeneratorRuntime.wrap(function _callee$(_context) {
                          while (1) {
                            switch (_context.prev = _context.next) {
                              case 0:
                                return _context.abrupt("return", isValid);

                              case 1:
                              case "end":
                                return _context.stop();
                            }
                          }
                        }, _callee);
                      }));
                      updatedValidation[id] = isValid;

                    case 6:
                    case "end":
                      return _context2.stop();
                  }
                }
              }, _loop);
            });
            _i3 = 0, _Object$entries2 = Object.entries(contents.current);

          case 5:
            if (!(_i3 < _Object$entries2.length)) {
              _context3.next = 10;
              break;
            }

            return _context3.delegateYield(_loop(), "t0", 7);

          case 7:
            _i3++;
            _context3.next = 5;
            break;

          case 10:
            return _context3.abrupt("return", Boolean(updateContentValidity(updatedValidation)));

          case 11:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee2);
  })), [updateContentValidity]);
  /**
   * Update a content. It replaces the content in our "contents" map and update
   * the state validation object.
   */

  var updateContentAt = useCallback(function (contentId, content) {
    contents.current[contentId] = content;

    var updatedValidity = _defineProperty({}, contentId, content.isValid);

    var isValid = updateContentValidity(updatedValidity);

    if (onChange !== undefined) {
      onChange({
        isValid: isValid,
        validate: validate,
        getData: getData
      });
    }
  }, [updateContentValidity, onChange]);
  /**
   * When a content unmounts we want to save its current data state so we will be able
   * to provide it as "defaultValue" the next time the component is mounted.
   */

  var saveSnapshotAndRemoveContent = useCallback(function (contentId) {
    if (contents.current[contentId]) {
      // Merge the data in our stateData
      var updatedData = _defineProperty({}, contentId, contents.current[contentId].getData());

      updateContentDataAt(updatedData); // Remove the content from our map

      delete contents.current[contentId];
    }
  }, [updateContentDataAt]);
  return {
    getData: getData,
    validate: validate,
    validation: validation,
    updateContentAt: updateContentAt,
    saveSnapshotAndRemoveContent: saveSnapshotAndRemoveContent
  };
}