/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect } from 'react';
import { EuiFormRow, EuiFieldNumber } from '@elastic/eui';

/**
 * Use only this component instead of NumberInputOption in 'number_input.tsx'.
 * It is required for compatibility with TS 3.7.0
 *
 * @param {number} props.value Should be numeric only
 */
function RequiredNumberInputOption(_ref) {
  var disabled = _ref.disabled,
      error = _ref.error,
      isInvalid = _ref.isInvalid,
      label = _ref.label,
      max = _ref.max,
      min = _ref.min,
      paramName = _ref.paramName,
      step = _ref.step,
      value = _ref.value,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      dataTestSubj = _ref['data-test-subj'];
  var isValid = value !== null;
  useEffect(function () {
    setValidity(paramName, isValid);
    return function () {
      return setValidity(paramName, true);
    };
  }, [isValid, paramName, setValidity]);
  var onChange = useCallback(function (ev) {
    return setValue(paramName, isNaN(ev.target.valueAsNumber) ? null : ev.target.valueAsNumber);
  }, [setValue, paramName]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    error: error,
    isInvalid: isInvalid,
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    compressed: true,
    fullWidth: true,
    required: true,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    isInvalid: !isValid,
    step: step,
    max: max,
    min: min,
    value: value === null ? '' : value,
    onChange: onChange
  }));
}

export { RequiredNumberInputOption };