function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { merge } from 'lodash'; // @ts-ignore not really worth typing

import { KFetchError } from './kfetch_error';
var interceptors = [];
export var resetInterceptors = function resetInterceptors() {
  return interceptors.length = 0;
};
export var addInterceptor = function addInterceptor(interceptor) {
  return interceptors.push(interceptor);
};
export function createKfetch(http) {
  return function kfetch(options) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$prependBasePath = _ref.prependBasePath,
        prependBasePath = _ref$prependBasePath === void 0 ? true : _ref$prependBasePath;

    return responseInterceptors(requestInterceptors(withDefaultOptions(options)).then(function (_ref2) {
      var pathname = _ref2.pathname,
          restOptions = _objectWithoutProperties(_ref2, ["pathname"]);

      return http.fetch(pathname, _objectSpread(_objectSpread({}, restOptions), {}, {
        prependBasePath: prependBasePath
      }));
    }).catch(function (err) {
      throw new KFetchError(err.response || {
        statusText: err.message
      }, err.body);
    }));
  };
} // Request/response interceptors are called in opposite orders.
// Request hooks start from the newest interceptor and end with the oldest.

function requestInterceptors(config) {
  return interceptors.reduceRight(function (acc, interceptor) {
    return acc.then(interceptor.request, interceptor.requestError);
  }, Promise.resolve(config));
} // Response hooks start from the oldest interceptor and end with the newest.


function responseInterceptors(responsePromise) {
  return interceptors.reduce(function (acc, interceptor) {
    return acc.then(interceptor.response, interceptor.responseError);
  }, responsePromise);
}

export function withDefaultOptions(options) {
  var withDefaults = merge({
    method: 'GET',
    credentials: 'same-origin',
    headers: {
      'Content-Type': 'application/json'
    }
  }, options);

  if (options && options.headers && 'Content-Type' in options.headers && options.headers['Content-Type'] === undefined) {
    // TS thinks headers could be undefined here, but that isn't possible because
    // of the merge above.
    // @ts-ignore
    withDefaults.headers['Content-Type'] = undefined;
  }

  return withDefaults;
}