/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export function areHashesDifferentButDecodedHashesEquals(urlA, urlB) {
  var getHash = function getHash(url) {
    var _url$split$;

    return (_url$split$ = url.split('#')[1]) !== null && _url$split$ !== void 0 ? _url$split$ : '';
  };

  var hashA = getHash(urlA);
  var decodedHashA = decodeURIComponent(hashA);
  var hashB = getHash(urlB);
  var decodedHashB = decodeURIComponent(hashB);
  return hashA !== hashB && decodedHashA === decodedHashB;
}