function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiHeaderLogo } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React from 'react';
import { useObservable } from 'react-use';
import Url from 'url';

function findClosestAnchor(element) {
  var current = element;

  while (current) {
    if (current.tagName === 'A') {
      return current;
    }

    if (!current.parentElement || current.parentElement === document.body) {
      return undefined;
    }

    current = current.parentElement;
  }
}

function _onClick(event, forceNavigation, navLinks, navigateToApp) {
  var anchor = findClosestAnchor(event.nativeEvent.target);

  if (!anchor) {
    return;
  }

  var navLink = navLinks.find(function (item) {
    return item.href === anchor.href;
  });

  if (navLink && navLink.disabled) {
    event.preventDefault();
    return;
  }

  if (event.isDefaultPrevented() || event.altKey || event.metaKey || event.ctrlKey) {
    return;
  }

  if (forceNavigation) {
    var toParsed = Url.parse(anchor.href);
    var fromParsed = Url.parse(document.location.href);
    var sameProto = toParsed.protocol === fromParsed.protocol;
    var sameHost = toParsed.host === fromParsed.host;
    var samePath = toParsed.path === fromParsed.path;

    if (sameProto && sameHost && samePath) {
      if (toParsed.hash) {
        document.location.reload();
      } // event.preventDefault() keeps the browser from seeing the new url as an update
      // and even setting window.location does not mimic that behavior, so instead
      // we use stopPropagation() to prevent angular from seeing the click and
      // starting a digest cycle/attempting to handle it in the router.


      event.stopPropagation();
    }
  } else {
    navigateToApp('home');
    event.preventDefault();
  }
}

export function HeaderLogo(_ref) {
  var href = _ref.href,
      navigateToApp = _ref.navigateToApp,
      observables = _objectWithoutProperties(_ref, ["href", "navigateToApp"]);

  var forceNavigation = useObservable(observables.forceNavigation$, false);
  var navLinks = useObservable(observables.navLinks$, []);
  return /*#__PURE__*/React.createElement(EuiHeaderLogo, {
    "data-test-subj": "logo",
    iconType: "logoElastic",
    onClick: function onClick(e) {
      return _onClick(e, forceNavigation, navLinks, navigateToApp);
    },
    href: href,
    "aria-label": i18n.translate('core.ui.chrome.headerGlobalNav.goHomePageIconAriaLabel', {
      defaultMessage: 'Go to home page'
    })
  });
}