"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueToggleFilter = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _filter_group = require("../../filter_group");

var _predicate = require("../../../services/predicate");

var _query = require("../query");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var FieldValueToggleFilter =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(FieldValueToggleFilter, _Component);

  function FieldValueToggleFilter() {
    (0, _classCallCheck2.default)(this, FieldValueToggleFilter);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(FieldValueToggleFilter).apply(this, arguments));
  }

  (0, _createClass2.default)(FieldValueToggleFilter, [{
    key: "resolveDisplay",
    value: function resolveDisplay(clause) {
      var _this$props$config = this.props.config,
          name = _this$props$config.name,
          negatedName = _this$props$config.negatedName;

      if ((0, _predicate.isNil)(clause)) {
        return {
          hasActiveFilters: false,
          name: name
        };
      }

      return _query.Query.isMust(clause) ? {
        hasActiveFilters: true,
        name: name
      } : {
        hasActiveFilters: true,
        name: negatedName ? negatedName : "Not ".concat(name)
      };
    }
  }, {
    key: "valueChanged",
    value: function valueChanged(checked) {
      var _this$props$config2 = this.props.config,
          field = _this$props$config2.field,
          value = _this$props$config2.value,
          operator = _this$props$config2.operator;
      var query = checked ? this.props.query.removeSimpleFieldValue(field, value) : this.props.query.addSimpleFieldValue(field, value, true, operator);
      this.props.onChange(query);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          query = _this$props.query,
          config = _this$props.config;
      var clause = query.getSimpleFieldClause(config.field, config.value);
      var checked = !(0, _predicate.isNil)(clause);

      var _this$resolveDisplay = this.resolveDisplay(clause),
          hasActiveFilters = _this$resolveDisplay.hasActiveFilters,
          name = _this$resolveDisplay.name;

      var onClick = function onClick() {
        _this.valueChanged(checked);
      };

      return _react.default.createElement(_filter_group.EuiFilterButton, {
        onClick: onClick,
        hasActiveFilters: hasActiveFilters,
        "aria-pressed": !!hasActiveFilters
      }, name);
    }
  }]);
  return FieldValueToggleFilter;
}(_react.Component);

exports.FieldValueToggleFilter = FieldValueToggleFilter;
FieldValueToggleFilter.propTypes = {
  index: _propTypes.default.number.isRequired,
  config: _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle"]).isRequired,
    field: _propTypes.default.string.isRequired,
    value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["date"]).isRequired,
      raw: _propTypes.default.any.isRequired,
      granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
        es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
        js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
        isSame: _propTypes.default.func.isRequired,
        start: _propTypes.default.func.isRequired,
        startOfNext: _propTypes.default.func.isRequired,
        iso8601: _propTypes.default.func.isRequired
      }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
      text: _propTypes.default.string.isRequired,
      resolve: _propTypes.default.func.isRequired
    }).isRequired]).isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired,
  query: _propTypes.default.any.isRequired,
  onChange: _propTypes.default.func.isRequired
};
FieldValueToggleFilter.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "resolveDisplay",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "clause",
      "type": null
    }],
    "returns": null
  }, {
    "name": "valueChanged",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "checked",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "FieldValueToggleFilter",
  "props": {
    "index": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": ""
    },
    "config": {
      "type": {
        "name": "shape",
        "value": {
          "type": {
            "name": "enum",
            "value": [{
              "value": "\"field_value_toggle\"",
              "computed": false
            }],
            "required": true
          },
          "field": {
            "name": "string",
            "required": true
          },
          "value": {
            "name": "union",
            "value": [{
              "name": "string"
            }, {
              "name": "number"
            }, {
              "name": "bool"
            }, {
              "name": "shape",
              "value": {
                "type": {
                  "name": "enum",
                  "value": [{
                    "value": "\"date\"",
                    "computed": false
                  }],
                  "required": true
                },
                "raw": {
                  "name": "any",
                  "required": true
                },
                "granularity": {
                  "name": "union",
                  "value": [{
                    "name": "shape",
                    "value": {
                      "es": {
                        "name": "enum",
                        "value": [{
                          "value": "\"d\"",
                          "computed": false
                        }, {
                          "value": "\"w\"",
                          "computed": false
                        }, {
                          "value": "\"M\"",
                          "computed": false
                        }, {
                          "value": "\"y\"",
                          "computed": false
                        }],
                        "required": true
                      },
                      "js": {
                        "name": "enum",
                        "value": [{
                          "value": "\"day\"",
                          "computed": false
                        }, {
                          "value": "\"week\"",
                          "computed": false
                        }, {
                          "value": "\"month\"",
                          "computed": false
                        }, {
                          "value": "\"year\"",
                          "computed": false
                        }],
                        "required": true
                      },
                      "isSame": {
                        "name": "func",
                        "required": true
                      },
                      "start": {
                        "name": "func",
                        "required": true
                      },
                      "startOfNext": {
                        "name": "func",
                        "required": true
                      },
                      "iso8601": {
                        "name": "func",
                        "required": true
                      }
                    }
                  }, {
                    "name": "enum",
                    "value": [{
                      "value": "undefined",
                      "computed": true
                    }]
                  }],
                  "required": true
                },
                "text": {
                  "name": "string",
                  "required": true
                },
                "resolve": {
                  "name": "func",
                  "required": true
                }
              }
            }],
            "required": true
          },
          "name": {
            "name": "string",
            "required": true
          },
          "negatedName": {
            "name": "string",
            "required": false
          },
          "available": {
            "name": "func",
            "required": false
          },
          "operator": {
            "name": "enum",
            "value": [{
              "value": "\"eq\"",
              "computed": false
            }, {
              "value": "\"exact\"",
              "computed": false
            }, {
              "value": "\"gt\"",
              "computed": false
            }, {
              "value": "\"gte\"",
              "computed": false
            }, {
              "value": "\"lt\"",
              "computed": false
            }, {
              "value": "\"lte\"",
              "computed": false
            }],
            "required": false
          }
        }
      },
      "required": true,
      "description": ""
    },
    "query": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    }
  }
};