"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var icon_1 = require("../icons/icon");
function Color(_a) {
    var color = _a.color, _b = _a.isSeriesHidden, isSeriesHidden = _b === void 0 ? false : _b, hasColorPicker = _a.hasColorPicker, onClick = _a.onClick;
    if (isSeriesHidden) {
        return (react_1.default.createElement("div", { className: "echLegendItem__color", "aria-label": "series hidden", title: "series hidden" },
            react_1.default.createElement(icon_1.Icon, { type: "eyeClosed", viewBox: "-3 -3 22 22" })));
    }
    var colorClasses = classnames_1.default('echLegendItem__color', {
        'echLegendItem__color--changable': hasColorPicker,
    });
    return (react_1.default.createElement("div", { onClick: onClick, className: colorClasses, "aria-label": "series color", title: "series color" },
        react_1.default.createElement(icon_1.Icon, { type: "dot", color: color })));
}
exports.Color = Color;
//# sourceMappingURL=color.js.map