/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContainerEntryGettable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.AbstractTreeNodeFactoryProvider;
import org.jd.gui.view.data.TreeNodeBean;

public class FileTreeNodeFactoryProvider
extends AbstractTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(FileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/file_plain_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf(47);
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
    }

    protected static class TreeNode
    extends DefaultMutableTreeNode
    implements ContainerEntryGettable,
    UriGettable {
        protected Container.Entry entry;

        public TreeNode(Container.Entry entry, Object userObject) {
            super(userObject);
            this.entry = entry;
        }

        @Override
        public Container.Entry getEntry() {
            return this.entry;
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }
    }
}

