/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.SortedSet;
import org.gradle.internal.normalization.java.impl.AccessibleMember;
import org.gradle.internal.normalization.java.impl.AnnotationMember;

public abstract class AnnotatableMember
extends AccessibleMember {
    private final SortedSet<AnnotationMember> annotations = Sets.newTreeSet();
    private final String signature;

    public AnnotatableMember(int access, String name, String signature) {
        super(access, name);
        this.signature = signature;
    }

    public SortedSet<AnnotationMember> getAnnotations() {
        return ImmutableSortedSet.copyOf(this.annotations);
    }

    public void addAnnotation(AnnotationMember annotationMember) {
        this.annotations.add(annotationMember);
    }

    public String getSignature() {
        return this.signature;
    }

    protected ComparisonChain compare(AnnotatableMember o) {
        return super.compare(o).compare((Comparable)((Object)(this.signature == null ? "" : this.signature)), (Comparable)((Object)(o.signature == null ? "" : o.signature)));
    }
}

