/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.Collections;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.util.GUtil;

public class IvyUtil {
    private static final Object MODULE_ID_LOCK = new Object();

    public static ModuleRevisionId createModuleRevisionId(String group, String name, String version) {
        return IvyUtil.createModuleRevisionId(IvyUtil.emptyStringIfNull(group), name, null, IvyUtil.emptyStringIfNull(version), Collections.emptyMap());
    }

    public static ModuleRevisionId createModuleRevisionId(ModuleComponentIdentifier id) {
        return IvyUtil.createModuleRevisionId(id.getGroup(), id.getModule(), id.getVersion());
    }

    private static String emptyStringIfNull(String value) {
        return (String)GUtil.elvis((Object)value, (Object)"");
    }

    public static ModuleRevisionId createModuleRevisionId(String org, String name, String branch, String rev, Map<String, String> extraAttributes) {
        return IvyUtil.createModuleRevisionId(org, name, branch, rev, extraAttributes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId createModuleRevisionId(String org, String name, String branch, String revConstraint, Map<String, String> extraAttributes, boolean replaceNullBranchWithDefault) {
        Object object = MODULE_ID_LOCK;
        synchronized (object) {
            return ModuleRevisionId.newInstance((String)org, (String)name, (String)branch, (String)revConstraint, extraAttributes, (boolean)replaceNullBranchWithDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleId createModuleId(String org, String name) {
        Object object = MODULE_ID_LOCK;
        synchronized (object) {
            return ModuleId.newInstance((String)org, (String)name);
        }
    }
}

