/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalWrapper;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class DateHistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<DateHistogramValuesSourceBuilder>
implements DateIntervalConsumer {
    static final String TYPE = "date_histogram";
    static final ObjectParser<DateHistogramValuesSourceBuilder, String> PARSER = ObjectParser.fromBuilder((String)"date_histogram", DateHistogramValuesSourceBuilder::new);
    private ZoneId timeZone = null;
    private DateIntervalWrapper dateHistogramInterval = new DateIntervalWrapper();
    private long offset = 0L;

    public DateHistogramValuesSourceBuilder(String name) {
        super(name, ValueType.DATE);
    }

    protected DateHistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.dateHistogramInterval = new DateIntervalWrapper(in);
        this.timeZone = in.readOptionalZoneId();
        if (in.getVersion().onOrAfter(Version.V_7_6_0)) {
            this.offset = in.readLong();
        }
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.dateHistogramInterval.writeTo(out);
        out.writeOptionalZoneId(this.timeZone);
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeLong(this.offset);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.dateHistogramInterval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateHistogramInterval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateHistogramValuesSourceBuilder other = (DateHistogramValuesSourceBuilder)obj;
        return Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.timeZone, other.timeZone);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    @Deprecated
    public long interval() {
        return this.dateHistogramInterval.interval();
    }

    @Deprecated
    public DateHistogramValuesSourceBuilder interval(long interval) {
        this.dateHistogramInterval.interval(interval);
        return this;
    }

    @Override
    @Deprecated
    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval.dateHistogramInterval();
    }

    @Deprecated
    public DateHistogramValuesSourceBuilder dateHistogramInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.dateHistogramInterval(interval);
        return this;
    }

    public DateHistogramValuesSourceBuilder calendarInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.calendarInterval(interval);
        return this;
    }

    public DateHistogramValuesSourceBuilder fixedInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.fixedInterval(interval);
        return this;
    }

    public DateHistogramInterval getIntervalAsCalendar() {
        return this.dateHistogramInterval.getAsCalendarInterval();
    }

    public DateHistogramInterval getIntervalAsFixed() {
        return this.dateHistogramInterval.getAsFixedInterval();
    }

    public DateHistogramValuesSourceBuilder timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public ZoneId timeZone() {
        return this.timeZone;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramValuesSourceBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config) throws IOException {
        ValuesSource orig;
        Rounding rounding = this.dateHistogramInterval.createRounding(this.timeZone(), this.offset);
        ValuesSource valuesSource = orig = config.hasValues() ? config.getValuesSource() : null;
        if (orig == null) {
            orig = ValuesSource.Numeric.EMPTY;
        }
        if (orig instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)orig;
            Rounding.Prepared preparedRounding = rounding.prepareForUnknown();
            RoundingValuesSource vs = new RoundingValuesSource(numeric, preparedRounding);
            DocValueFormat docValueFormat = this.format() == null ? DocValueFormat.RAW : config.format();
            MappedFieldType fieldType = config.fieldType();
            return new CompositeValuesSourceConfig(this.name, fieldType, vs, docValueFormat, this.order(), this.missingBucket(), config.script() != null);
        }
        throw new IllegalArgumentException("invalid source, expected numeric, got " + orig.getClass().getSimpleName());
    }

    static {
        PARSER.declareString(CompositeValuesSourceBuilder::format, new ParseField("format", new String[0]));
        DateIntervalWrapper.declareIntervalFields(PARSER);
        PARSER.declareField(DateHistogramValuesSourceBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(DateHistogramValuesSourceBuilder::timeZone, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, new ParseField("time_zone", new String[0]), ObjectParser.ValueType.LONG);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, ValueType.NUMERIC);
    }
}

