/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context;

import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolderStrategy;
import org.springframework.security.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class GlobalSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static SecurityContext contextHolder;

    public void clearContext() {
        contextHolder = null;
    }

    public SecurityContext getContext() {
        if (contextHolder == null) {
            contextHolder = new SecurityContextImpl();
        }
        return contextHolder;
    }

    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        contextHolder = context;
    }
}

