/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet.internal;

import javax.servlet.ServletContext;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Protocol;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.EntityClientHelper;
import org.restlet.ext.servlet.internal.ServletWarEntity;

public class ServletWarClientHelper
extends EntityClientHelper {
    private volatile ServletContext servletContext;

    public ServletWarClientHelper(Client client, ServletContext servletContext) {
        super(client);
        this.getProtocols().clear();
        this.getProtocols().add(Protocol.WAR);
        this.servletContext = servletContext;
    }

    @Override
    public Entity getEntity(String decodedPath) {
        return new ServletWarEntity(this.getServletContext(), decodedPath, this.getMetadataService());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void handleLocal(Request request, Response response, String decodedPath) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.WAR.getSchemeName().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only WAR is supported.");
        }
        super.handleLocal(request, response, decodedPath);
    }
}

