/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import org.carrot2.core.LanguageCode;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.util.factory.CachedInstanceFactoryDecorator;
import org.carrot2.util.factory.IFactory;

public final class LanguageModel {
    private final LanguageCode languageCode;
    private final IFactory<IStemmer> stemmerFactory;
    private final IFactory<ITokenizer> tokenizerFactory;
    private final IFactory<ILexicalData> lexicalDataFactory;

    LanguageModel(LanguageCode languageCode, IFactory<IStemmer> stemmerFactory, IFactory<ITokenizer> tokenizerFactory, IFactory<ILexicalData> lexicalDataFactory) {
        this.languageCode = languageCode;
        this.stemmerFactory = new CachedInstanceFactoryDecorator<IStemmer>(stemmerFactory);
        this.tokenizerFactory = new CachedInstanceFactoryDecorator<ITokenizer>(tokenizerFactory);
        this.lexicalDataFactory = new CachedInstanceFactoryDecorator<ILexicalData>(lexicalDataFactory);
    }

    public static LanguageModel create(final LanguageCode languageCode, final IStemmerFactory stemmerFactory, final ITokenizerFactory tokenizerFactory, final ILexicalDataFactory lexicalDataFactory) {
        return new LanguageModel(languageCode, new IFactory<IStemmer>(){

            @Override
            public IStemmer createInstance() {
                return stemmerFactory.getStemmer(languageCode);
            }
        }, new IFactory<ITokenizer>(){

            @Override
            public ITokenizer createInstance() {
                return tokenizerFactory.getTokenizer(languageCode);
            }
        }, new IFactory<ILexicalData>(){

            @Override
            public ILexicalData createInstance() {
                return lexicalDataFactory.getLexicalData(languageCode);
            }
        });
    }

    public LanguageCode getLanguageCode() {
        return this.languageCode;
    }

    public ILexicalData getLexicalData() {
        return this.lexicalDataFactory.createInstance();
    }

    public IStemmer getStemmer() {
        return this.stemmerFactory.createInstance();
    }

    public ITokenizer getTokenizer() {
        return this.tokenizerFactory.createInstance();
    }
}

