/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;

public abstract class RrdBackend {
    protected static final ByteOrder BYTEORDER = ByteOrder.BIG_ENDIAN;
    private static final char STARTPRIVATEAREA = '\ue000';
    private static final char ENDPRIVATEAREA = '\uf8ff';
    private static final int STARTPRIVATEAREACODEPOINT = Character.codePointAt(new char[]{'\ue000'}, 0);
    private static final int ENDPRIVATEAREACODEPOINT = Character.codePointAt(new char[]{'\uf8ff'}, 0);
    private static final int PRIVATEAREASIZE = ENDPRIVATEAREACODEPOINT - STARTPRIVATEAREACODEPOINT + 1;
    private static final int MAXUNSIGNEDSHORT = 65535;
    private static volatile boolean instanceCreated = false;
    private final String path;
    private RrdBackendFactory factory;
    private long nextBigStringOffset = -1L;
    private PhantomReference<RrdDb> ref;

    protected RrdBackend(String path) {
        this.path = path;
        instanceCreated = true;
    }

    void done(RrdBackendFactory factory, PhantomReference<RrdDb> ref) {
        this.factory = factory;
        this.ref = ref;
    }

    public RrdBackendFactory getFactory() {
        return this.factory;
    }

    public String getPath() {
        return this.path;
    }

    public URI getUri() {
        return this.factory.getUri(this.path);
    }

    protected abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void read(long var1, byte[] var3) throws IOException;

    public abstract long getLength() throws IOException;

    protected abstract void setLength(long var1) throws IOException;

    protected abstract void close() throws IOException;

    protected void rrdClose() throws IOException {
        try {
            this.close();
        }
        finally {
            if (this.ref != null) {
                this.ref.clear();
            }
        }
    }

    protected boolean isCachingAllowed() {
        return this.factory.cachingAllowed;
    }

    public final byte[] readAll() throws IOException {
        byte[] b = new byte[(int)this.getLength()];
        this.read(0L, b);
        return b;
    }

    protected void writeShort(long offset, short value) throws IOException {
        byte[] b = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value >>> 0 & 0xFF)};
        this.write(offset, b);
    }

    protected void writeInt(long offset, int value) throws IOException {
        this.write(offset, RrdBackend.getIntBytes(value));
    }

    protected void writeLong(long offset, long value) throws IOException {
        this.write(offset, RrdBackend.getLongBytes(value));
    }

    protected void writeDouble(long offset, double value) throws IOException {
        this.write(offset, RrdBackend.getDoubleBytes(value));
    }

    protected void writeDouble(long offset, double value, int count) throws IOException {
        byte[] b = RrdBackend.getDoubleBytes(value);
        byte[] image = new byte[8 * count];
        int k = 0;
        for (int i = 0; i < count; ++i) {
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
        }
        this.write(offset, image);
    }

    protected void writeDouble(long offset, double[] values) throws IOException {
        int count = values.length;
        byte[] image = new byte[8 * count];
        int k = 0;
        for (int i = 0; i < count; ++i) {
            byte[] b = RrdBackend.getDoubleBytes(values[i]);
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
        }
        this.write(offset, image);
    }

    protected final void writeString(long offset, String value) throws IOException {
        if (this.nextBigStringOffset < 0L) {
            this.nextBigStringOffset = this.getLength() - 2L;
        }
        if ((value = value.trim()).length() > 20) {
            String bigString = value;
            int byteStringLength = Math.min(65535, bigString.length());
            long bigStringOffset = this.nextBigStringOffset;
            this.nextBigStringOffset -= (long)(byteStringLength * 2 + 2);
            this.writeShort(bigStringOffset, (short)byteStringLength);
            this.writeString(bigStringOffset - (long)(bigString.length() * 2), bigString, byteStringLength);
            long reminder = bigStringOffset;
            StringBuilder newValue = new StringBuilder(value.substring(0, 20));
            int i = 20;
            while (reminder > 0L) {
                newValue.setCharAt(--i, Character.toChars((int)(reminder % (long)PRIVATEAREASIZE + (long)STARTPRIVATEAREACODEPOINT))[0]);
                reminder = (long)Math.floor((float)reminder / (float)PRIVATEAREASIZE);
            }
            value = newValue.toString();
        }
        this.writeString(offset, value, 20);
    }

    protected void writeString(long offset, String value, int length) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(length * 2);
        bbuf.order(BYTEORDER);
        bbuf.position(0);
        bbuf.limit(length * 2);
        CharBuffer cbuf = bbuf.asCharBuffer();
        cbuf.put(value);
        while (cbuf.position() < cbuf.limit()) {
            cbuf.put(' ');
        }
        this.write(offset, bbuf.array());
    }

    protected short readShort(long offset) throws IOException {
        byte[] b = new byte[2];
        this.read(offset, b);
        return (short)((b[0] << 8 & 0xFF00) + (b[1] & 0xFF));
    }

    protected int readInt(long offset) throws IOException {
        byte[] b = new byte[4];
        this.read(offset, b);
        return RrdBackend.getInt(b);
    }

    protected long readLong(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getLong(b);
    }

    protected double readDouble(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getDouble(b);
    }

    protected double[] readDouble(long offset, int count) throws IOException {
        int byteCount = 8 * count;
        byte[] image = new byte[byteCount];
        this.read(offset, image);
        double[] values = new double[count];
        int k = -1;
        for (int i = 0; i < count; ++i) {
            byte[] b = new byte[]{image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k]};
            values[i] = RrdBackend.getDouble(b);
        }
        return values;
    }

    protected CharBuffer getCharBuffer(long offset, int size) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(size * 2);
        bbuf.order(BYTEORDER);
        this.read(offset, bbuf.array());
        bbuf.position(0);
        bbuf.limit(size * 2);
        return bbuf.asCharBuffer();
    }

    protected final String readString(long offset) throws IOException {
        char c;
        CharBuffer cbuf = this.getCharBuffer(offset, 20);
        long realStringOffset = 0L;
        int i = -1;
        while (++i < 20 && (c = cbuf.charAt(20 - i - 1)) >= '\ue000' && c <= '\uf8ff') {
            realStringOffset = (long)((double)realStringOffset + (double)((long)c - (long)STARTPRIVATEAREACODEPOINT) * Math.pow(PRIVATEAREASIZE, i));
            cbuf.limit(20 - i - 1);
        }
        if (realStringOffset > 0L) {
            int bigStringSize = this.readShort(realStringOffset);
            if (bigStringSize < 0) {
                bigStringSize += 65536;
            }
            return this.getCharBuffer(realStringOffset - (long)(bigStringSize * 2), bigStringSize).toString();
        }
        return cbuf.slice().toString().trim();
    }

    private static byte[] getIntBytes(int value) {
        byte[] b = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 0 & 0xFF)};
        return b;
    }

    private static byte[] getLongBytes(long value) {
        byte[] b = new byte[]{(byte)((int)(value >>> 56) & 0xFF), (byte)((int)(value >>> 48) & 0xFF), (byte)((int)(value >>> 40) & 0xFF), (byte)((int)(value >>> 32) & 0xFF), (byte)((int)(value >>> 24) & 0xFF), (byte)((int)(value >>> 16) & 0xFF), (byte)((int)(value >>> 8) & 0xFF), (byte)((int)(value >>> 0) & 0xFF)};
        return b;
    }

    private static byte[] getDoubleBytes(double value) {
        return RrdBackend.getLongBytes(Double.doubleToLongBits(value));
    }

    private static int getInt(byte[] b) {
        assert (b.length == 4) : "Invalid number of bytes for integer conversion";
        return (b[0] << 24 & 0xFF000000) + (b[1] << 16 & 0xFF0000) + (b[2] << 8 & 0xFF00) + (b[3] & 0xFF);
    }

    private static long getLong(byte[] b) {
        assert (b.length == 8) : "Invalid number of bytes for long conversion";
        int high = RrdBackend.getInt(new byte[]{b[0], b[1], b[2], b[3]});
        int low = RrdBackend.getInt(new byte[]{b[4], b[5], b[6], b[7]});
        return ((long)high << 32) + ((long)low & 0xFFFFFFFFL);
    }

    private static double getDouble(byte[] b) {
        assert (b.length == 8) : "Invalid number of bytes for double conversion";
        return Double.longBitsToDouble(RrdBackend.getLong(b));
    }

    static boolean isInstanceCreated() {
        return instanceCreated;
    }
}

