/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlComposedTypeBase;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class YamlAnyOfType
extends YamlComposedTypeBase {
    public static YamlMetaType anyOf(YamlMetaType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        if (types.length == 1) {
            return types[0];
        }
        String name = "AnyOf[" + Stream.of(types).map(YamlMetaType::getDisplayName).collect(Collectors.joining()) + "]";
        return new YamlAnyOfType(name, YamlAnyOfType.flattenTypes(types));
    }

    @Override
    protected YamlMetaType composeTypes(YamlMetaType ... types) {
        return YamlAnyOfType.anyOf(types);
    }

    protected YamlAnyOfType(@NotNull String typeName, List<YamlMetaType> types) {
        if (typeName == null) {
            YamlAnyOfType.$$$reportNull$$$0(0);
        }
        super(typeName, types);
    }

    @Override
    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        if (keyValue == null) {
            YamlAnyOfType.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            YamlAnyOfType.$$$reportNull$$$0(2);
        }
        List<ProblemsHolder> allProblems = YamlAnyOfType.allProblemsOrEmpty(problemsHolder, this.listNonScalarSubTypes(), (nextType, nextHolder) -> nextType.validateKey(keyValue, (ProblemsHolder)nextHolder));
        allProblems.stream().flatMap(h -> h.getResults().stream()).forEach(arg_0 -> ((ProblemsHolder)problemsHolder).registerProblem(arg_0));
    }

    @Override
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        List<YamlMetaType> types;
        if (value == null) {
            YamlAnyOfType.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            YamlAnyOfType.$$$reportNull$$$0(4);
        }
        if (value instanceof YAMLScalar) {
            types = this.listScalarSubTypes();
            if (types.isEmpty()) {
                types = Collections.singletonList(this.listNonScalarSubTypes().get(0));
            }
        } else {
            types = this.listNonScalarSubTypes();
            if (types.isEmpty()) {
                types = Collections.singletonList(this.listScalarSubTypes().get(0));
            }
        }
        List<ProblemsHolder> allProblems = YamlAnyOfType.allProblemsOrEmpty(problemsHolder, types, (nextType, nextHolder) -> nextType.validateValue(value, (ProblemsHolder)nextHolder));
        allProblems.stream().flatMap(h -> h.getResults().stream()).forEach(arg_0 -> ((ProblemsHolder)problemsHolder).registerProblem(arg_0));
    }

    @Override
    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        if (insertedScalar == null) {
            YamlAnyOfType.$$$reportNull$$$0(5);
        }
        List list = this.streamSubTypes().flatMap(type -> type.getValueLookups(insertedScalar, completionContext).stream()).collect(Collectors.toList());
        if (list == null) {
            YamlAnyOfType.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static List<ProblemsHolder> allProblemsOrEmpty(@NotNull ProblemsHolder problemsHolder, @NotNull List<YamlMetaType> types, @NotNull BiConsumer<YamlMetaType, ProblemsHolder> oneValidation) {
        if (problemsHolder == null) {
            YamlAnyOfType.$$$reportNull$$$0(7);
        }
        if (types == null) {
            YamlAnyOfType.$$$reportNull$$$0(8);
        }
        if (oneValidation == null) {
            YamlAnyOfType.$$$reportNull$$$0(9);
        }
        SmartList problems = new SmartList();
        for (YamlMetaType nextType : types) {
            ProblemsHolder nextHolder = YamlAnyOfType.makeCopy(problemsHolder);
            oneValidation.accept(nextType, nextHolder);
            if (!nextHolder.hasResults()) {
                return Collections.emptyList();
            }
            problems.add(nextHolder);
        }
        return problems;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlAnyOfType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneValidation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlAnyOfType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLookups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateKey";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueLookups";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allProblemsOrEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

