/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.editorconfig.configmanagement.editor.EditorConfigEditorProvider;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewFile
extends LightVirtualFile
implements CodeStyleSettingsListener,
Disposable {
    private final Project myProject;
    private final String myOriginalPath;
    private final Document myDocument;

    EditorConfigPreviewFile(@NotNull Project project, @NotNull VirtualFile originalFile, @NotNull Document document) {
        if (project == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(1);
        }
        if (document == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(2);
        }
        super(originalFile.getName());
        this.myProject = project;
        this.myOriginalPath = originalFile.getPath();
        this.myDocument = document;
        Language language = EditorConfigEditorProvider.getLanguage(originalFile);
        if (language != null) {
            super.setLanguage(language);
        }
        super.setContent((Object)this, (CharSequence)this.myDocument.getText(), false);
        this.reformat();
        CodeStyleSettingsManager.getInstance((Project)project).addListener((CodeStyleSettingsListener)this);
    }

    @NotNull
    private PsiFile createPsi(@NotNull FileType fileType) {
        if (fileType == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("preview", fileType, (CharSequence)this.myDocument.getText(), LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            EditorConfigPreviewFile.$$$reportNull$$$0(5);
        }
        this.reformat();
    }

    private void reformat() {
        if (!this.myProject.isInitialized()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PsiFile originalPsiFile = this.resolveOriginalPsi();
            if (originalPsiFile != null) {
                CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)originalPsiFile);
                PsiFile psiFile = this.createPsi(originalPsiFile.getFileType());
                CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)settings, () -> CodeStyleManager.getInstance((Project)this.myProject).reformatText(psiFile, 0, psiFile.getTextLength()));
                this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)psiFile.getText());
            }
        }), EditorConfigBundle.message("command.name.reformat"), null);
    }

    @Nullable
    public PsiFile resolveOriginalPsi() {
        Document document;
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(this.myOriginalPath, new String[0]), (boolean)true);
        if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
            return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        }
        return null;
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

