/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsUserImpl;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRCommitsListCellRenderer;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRCommitsBrowserComponent;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00140\u0013J\u0018\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0010H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0002R0\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRCommitsBrowserComponent;", "", "()V", "COMMITS_LIST_KEY", "Lcom/intellij/openapi/util/Key;", "Ljavax/swing/JList;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCOMMITS_LIST_KEY", "()Lcom/intellij/openapi/util/Key;", "unknownUser", "Lcom/intellij/vcs/log/impl/VcsUserImpl;", "create", "Ljavax/swing/JComponent;", "commitsModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "", "onCommitSelected", "Lkotlin/Function1;", "", "createCommitDetailsComponent", "model", "createUser", "Lcom/intellij/vcs/log/VcsUser;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "getHashAndAuthorText", "", "hash", "author", "committer", "intellij.vcs.github"})
public final class GHPRCommitsBrowserComponent {
    @NotNull
    private static final Key<JList<GHCommit>> COMMITS_LIST_KEY;
    private static final VcsUserImpl unknownUser;
    public static final GHPRCommitsBrowserComponent INSTANCE;

    @NotNull
    public final Key<JList<GHCommit>> getCOMMITS_LIST_KEY() {
        return COMMITS_LIST_KEY;
    }

    @NotNull
    public final JComponent create(@NotNull SingleValueModel<List<GHCommit>> commitsModel, @NotNull Function1<? super GHCommit, Unit> onCommitSelected) {
        Intrinsics.checkParameterIsNotNull(commitsModel, (String)"commitsModel");
        Intrinsics.checkParameterIsNotNull(onCommitSelected, (String)"onCommitSelected");
        CollectionListModel commitsListModel = new CollectionListModel(commitsModel.getValue());
        ActionManager actionManager = ActionManager.getInstance();
        JBList jBList = new JBList((ListModel)commitsListModel);
        boolean bl = false;
        boolean bl2 = false;
        JBList $this$apply = jBList;
        boolean bl3 = false;
        $this$apply.setSelectionMode(0);
        GHPRCommitsListCellRenderer renderer = new GHPRCommitsListCellRenderer();
        $this$apply.setCellRenderer((ListCellRenderer)renderer);
        UIUtil.putClientProperty((JComponent)((JComponent)$this$apply), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf((Object)renderer.getPanel()));
        StatusText statusText = $this$apply.getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"emptyText");
        statusText.setText(GithubBundle.message("pull.request.does.not.contain.commits", new Object[0]));
        bl = false;
        bl2 = false;
        Object it = jBList;
        boolean bl4 = false;
        ScrollingUtil.installActions((JList)((JList)it));
        GithubUIUtil.Lists.INSTANCE.installSelectionOnFocus((JList)it);
        GithubUIUtil.Lists.INSTANCE.installSelectionOnRightClick((JList)it);
        PopupHandler.installSelectionListPopup((JList)((JList)it), (ActionGroup)((ActionGroup)new DefaultActionGroup(new AnAction[]{actionManager.getAction("Github.PullRequest.Changes.Reload")})), (String)"unknown", (ActionManager)actionManager);
        new ListSpeedSearch((JList)it, (Function)create.commitsList.2.1.INSTANCE);
        JBList commitsList2 = jBList;
        commitsModel.addValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(commitsListModel, commitsModel, commitsList2){
            final /* synthetic */ CollectionListModel $commitsListModel;
            final /* synthetic */ SingleValueModel $commitsModel;
            final /* synthetic */ JBList $commitsList;

            public final void invoke() {
                List newList;
                List currentList = this.$commitsListModel.toList();
                if (Intrinsics.areEqual((Object)currentList, (Object)(newList = (List)this.$commitsModel.getValue())) ^ true) {
                    GHCommit selectedCommit = (GHCommit)this.$commitsList.getSelectedValue();
                    this.$commitsListModel.replaceAll(newList);
                    this.$commitsList.setSelectedValue((Object)selectedCommit, true);
                }
            }
            {
                this.$commitsListModel = collectionListModel;
                this.$commitsModel = singleValueModel;
                this.$commitsList = jBList;
                super(0);
            }
        }));
        SingleValueModel<Object> commitDetailsModel = new SingleValueModel<Object>(null);
        JComponent commitDetailsComponent = this.createCommitDetailsComponent(commitDetailsModel);
        commitsList2.addListSelectionListener(new ListSelectionListener(onCommitSelected, commitsList2){
            final /* synthetic */ Function1 $onCommitSelected;
            final /* synthetic */ JBList $commitsList;

            public final void valueChanged(ListSelectionEvent e) {
                ListSelectionEvent listSelectionEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionEvent, (String)"e");
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                this.$onCommitSelected.invoke(this.$commitsList.getSelectedValue());
            }
            {
                this.$onCommitSelected = function1;
                this.$commitsList = jBList;
            }
        });
        it = ScrollPaneFactory.createScrollPane((Component)((Component)commitsList2), (boolean)true);
        boolean bl5 = false;
        boolean bl6 = false;
        Object $this$apply2 = it;
        boolean bl7 = false;
        ((JComponent)$this$apply2).setOpaque(false);
        JViewport jViewport = ((JScrollPane)$this$apply2).getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
        jViewport.setOpaque(false);
        ((JScrollPane)$this$apply2).setHorizontalScrollBarPolicy(31);
        Object object = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ScrollPaneFactory.create\u2026TAL_SCROLLBAR_NEVER\n    }");
        Object commitsScrollPane = object;
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter(true, "Github.PullRequest.Commits.Browser", 0.7f);
        bl6 = false;
        boolean bl8 = false;
        OnePixelSplitter $this$apply3 = onePixelSplitter;
        boolean bl9 = false;
        $this$apply3.setFirstComponent((JComponent)commitsScrollPane);
        $this$apply3.setSecondComponent(commitDetailsComponent);
        UIUtil.putClientProperty((JComponent)((JComponent)$this$apply3), COMMITS_LIST_KEY, (Object)commitsList2);
        OnePixelSplitter commitsBrowser = onePixelSplitter;
        commitsList2.addListSelectionListener(new ListSelectionListener(commitsList2, commitDetailsModel, commitsListModel, commitsBrowser){
            final /* synthetic */ JBList $commitsList;
            final /* synthetic */ SingleValueModel $commitDetailsModel;
            final /* synthetic */ CollectionListModel $commitsListModel;
            final /* synthetic */ OnePixelSplitter $commitsBrowser;

            public final void valueChanged(ListSelectionEvent e) {
                ListSelectionEvent listSelectionEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionEvent, (String)"e");
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int index = this.$commitsList.getSelectedIndex();
                this.$commitDetailsModel.setValue(index != -1 ? (GHCommit)this.$commitsListModel.getElementAt(index) : null);
                this.$commitsBrowser.validate();
                this.$commitsBrowser.repaint();
                if (index != -1) {
                    ScrollingUtil.ensureRangeIsVisible((JList)((JList)this.$commitsList), (int)index, (int)index);
                }
            }
            {
                this.$commitsList = jBList;
                this.$commitDetailsModel = singleValueModel;
                this.$commitsListModel = collectionListModel;
                this.$commitsBrowser = onePixelSplitter;
            }
        });
        return (JComponent)commitsBrowser;
    }

    private final JComponent createCommitDetailsComponent(SingleValueModel<GHCommit> model2) {
        HtmlEditorPane htmlEditorPane = new HtmlEditorPane();
        boolean bl = false;
        boolean bl2 = false;
        HtmlEditorPane $this$apply = htmlEditorPane;
        boolean bl3 = false;
        $this$apply.setFont(FontUtil.getCommitMessageFont());
        HtmlEditorPane messagePane = htmlEditorPane;
        HtmlEditorPane htmlEditorPane2 = new HtmlEditorPane();
        bl2 = false;
        boolean bl4 = false;
        HtmlEditorPane $this$apply2 = htmlEditorPane2;
        boolean bl5 = false;
        $this$apply2.setFont(FontUtil.getCommitMetadataFont());
        HtmlEditorPane hashAndAuthorPane = htmlEditorPane2;
        ScrollablePanel scrollablePanel = new ScrollablePanel((LayoutManager)new VerticalLayout(UI.scale((int)10)));
        bl4 = false;
        boolean bl6 = false;
        ScrollablePanel $this$apply3 = scrollablePanel;
        boolean bl7 = false;
        $this$apply3.setBorder((Border)JBUI.Borders.empty((int)14, (int)14));
        $this$apply3.setBackground(CommitDetailsPanelKt.getCommitDetailsBackground());
        $this$apply3.add((Component)messagePane, (Object)"fill_h");
        $this$apply3.add((Component)hashAndAuthorPane, (Object)"fill_h");
        ScrollablePanel commitDetailsPanel = scrollablePanel;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)commitDetailsPanel), (boolean)true);
        bl6 = false;
        boolean bl8 = false;
        JScrollPane $this$apply4 = jScrollPane;
        boolean bl9 = false;
        $this$apply4.setVisible(false);
        $this$apply4.setOpaque(false);
        JViewport jViewport = $this$apply4.getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
        jViewport.setOpaque(false);
        $this$apply4.setHorizontalScrollBarPolicy(31);
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"ScrollPaneFactory.create\u2026TAL_SCROLLBAR_NEVER\n    }");
        JScrollPane commitDetailsScrollPane = jScrollPane2;
        model2.addAndInvokeValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(model2, messagePane, hashAndAuthorPane, commitDetailsScrollPane, commitDetailsPanel){
            final /* synthetic */ SingleValueModel $model;
            final /* synthetic */ HtmlEditorPane $messagePane;
            final /* synthetic */ HtmlEditorPane $hashAndAuthorPane;
            final /* synthetic */ JScrollPane $commitDetailsScrollPane;
            final /* synthetic */ ScrollablePanel $commitDetailsPanel;

            public final void invoke() {
                GHCommit commit = (GHCommit)this.$model.getValue();
                if (commit == null) {
                    this.$messagePane.setBody("");
                    this.$hashAndAuthorPane.setBody("");
                    this.$commitDetailsScrollPane.setVisible(false);
                } else {
                    String subject = "<b>" + commit.getMessageHeadlineHTML() + "</b>";
                    String body2 = commit.getMessageBodyHTML();
                    CharSequence charSequence = body2;
                    boolean bl = false;
                    String fullMessage = charSequence.length() > 0 ? subject + "<br><br>" + body2 : subject;
                    this.$messagePane.setBody(fullMessage);
                    this.$hashAndAuthorPane.setBody(GHPRCommitsBrowserComponent.access$getHashAndAuthorText(GHPRCommitsBrowserComponent.INSTANCE, commit.getOid(), commit.getAuthor(), commit.getCommitter()));
                    this.$commitDetailsScrollPane.setVisible(true);
                    this.$commitDetailsPanel.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ createCommitDetailsComponent.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.$messagePane.setSize(this.this$0.$messagePane.getWidth(), 0x3FFFFFFF);
                            this.this$0.$hashAndAuthorPane.setSize(this.this$0.$hashAndAuthorPane.getWidth(), 0x3FFFFFFF);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            {
                this.$model = singleValueModel;
                this.$messagePane = htmlEditorPane;
                this.$hashAndAuthorPane = htmlEditorPane2;
                this.$commitDetailsScrollPane = jScrollPane;
                this.$commitDetailsPanel = scrollablePanel;
                super(0);
            }
        }));
        return commitDetailsScrollPane;
    }

    private final String getHashAndAuthorText(String hash, GHGitActor author2, GHGitActor committer) {
        VcsUser authorUser = this.createUser(author2);
        Object object = author2;
        long authorTime = object != null && (object = ((GHGitActor)object).getDate()) != null ? ((Date)object).getTime() : 0L;
        VcsUser committerUser = this.createUser(committer);
        Object object2 = committer;
        long committerTime = object2 != null && (object2 = ((GHGitActor)object2).getDate()) != null ? ((Date)object2).getTime() : 0L;
        String string = CommitPresentationUtil.formatCommitHashAndAuthor((Hash)HashImpl.build((String)hash), (VcsUser)authorUser, (long)authorTime, (VcsUser)committerUser, (long)committerTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommitPresentationUtil.f\u2026itterUser, committerTime)");
        return string;
    }

    private final VcsUser createUser(GHGitActor actor) {
        GHGitActor gHGitActor = actor;
        String name = gHGitActor != null ? gHGitActor.getName() : null;
        GHGitActor gHGitActor2 = actor;
        String email = gHGitActor2 != null ? gHGitActor2.getEmail() : null;
        return name != null && email != null ? (VcsUser)new VcsUserImpl(name, email) : (VcsUser)unknownUser;
    }

    private GHPRCommitsBrowserComponent() {
    }

    static {
        GHPRCommitsBrowserComponent gHPRCommitsBrowserComponent;
        INSTANCE = gHPRCommitsBrowserComponent = new GHPRCommitsBrowserComponent();
        Key key = Key.create((String)"COMMITS_LIST");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<JList<GHCommit>>(\"COMMITS_LIST\")");
        COMMITS_LIST_KEY = key;
        unknownUser = new VcsUserImpl("unknown user", "");
    }

    public static final /* synthetic */ String access$getHashAndAuthorText(GHPRCommitsBrowserComponent $this, String hash, GHGitActor author2, GHGitActor committer) {
        return $this.getHashAndAuthorText(hash, author2, committer);
    }
}

