/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.highlighter;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.injection.LanguageGuesser;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0016H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFencePluginGeneratingProvider;", "()V", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult;", "cleanup", "", "escape", "html", "generateHtml", "language", "raw", "isApplicable", "", "onLAFChanged", "render", "lang", "Lcom/intellij/lang/Language;", "text", "toHex", "Ljava/awt/Color;", "CachedHTMLResult", "Companion", "intellij.markdown"})
public final class MarkdownCodeFencePreviewHighlighter
implements MarkdownCodeFencePluginGeneratingProvider {
    private final ConcurrentHashMap<String, CachedHTMLResult> values = new ConcurrentHashMap();
    private static final int expiration = 300000;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return LanguageGuesser.INSTANCE.guessLanguage(language) != null;
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw) {
        CachedHTMLResult.HTMLResult resolved;
        CachedHTMLResult cached;
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
        Language language2 = LanguageGuesser.INSTANCE.guessLanguage(language);
        if (language2 == null) {
            return this.escape(raw);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"LanguageGuesser.INSTANCE\u2026ge) ?: return escape(raw)");
        Language lang = language2;
        String md5 = MarkdownUtil.INSTANCE.md5(raw, language);
        CachedHTMLResult cachedHTMLResult = cached = this.values.get(md5);
        CachedHTMLResult.HTMLResult hTMLResult = resolved = cachedHTMLResult != null ? cachedHTMLResult.resolve() : null;
        if (resolved != null) {
            CachedHTMLResult cachedHTMLResult2 = cached;
            cachedHTMLResult2.setExpires(cachedHTMLResult2.getExpires() + (long)300000);
            return resolved.getHtml();
        }
        this.cleanup();
        String text = this.render(lang, raw);
        CachedHTMLResult html = new CachedHTMLResult(new SoftReference<String>(text), System.currentTimeMillis() + (long)300000);
        ((Map)this.values).put(md5, html);
        return text;
    }

    @Override
    public void onLAFChanged() {
        this.values.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanup() {
        void $this$filterTo$iv$iv;
        long time = System.currentTimeMillis();
        Map $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((CachedHTMLResult)it.getValue()).getExpires() < time)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set toRemove = destination$iv$iv.keySet();
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            this.values.remove(it);
        }
    }

    private final String render(Language lang, String text) {
        SyntaxHighlighter highlighter;
        LightVirtualFile file = new LightVirtualFile("markdown_temp", (CharSequence)text);
        SyntaxHighlighter syntaxHighlighter = highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, null, (VirtualFile)((VirtualFile)file));
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxHighlighter, (String)"highlighter");
        Lexer lexer = syntaxHighlighter.getHighlightingLexer();
        Intrinsics.checkExpressionValueIsNotNull((Object)lexer, (String)"highlighter.highlightingLexer");
        Lexer lexer2 = lexer;
        lexer2.start((CharSequence)text);
        StringBuilder html = new StringBuilder(text.length());
        while (lexer2.getTokenType() != null) {
            String string;
            Color color;
            IElementType type = lexer2.getTokenType();
            Object[] objectArray = highlighter.getTokenHighlights(type);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"highlighter.getTokenHighlights(type)");
            TextAttributesKey highlights = (TextAttributesKey)ArraysKt.lastOrNull((Object[])objectArray);
            TextAttributesKey textAttributesKey = highlights;
            Color color2 = textAttributesKey != null && (textAttributesKey = textAttributesKey.getDefaultAttributes()) != null ? textAttributesKey.getForegroundColor() : (color = null);
            if (color != null) {
                StringBuilder stringBuilder = new StringBuilder().append("<font color=\"").append(this.toHex(color)).append("\">");
                String string2 = lexer2.getTokenText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lexer.tokenText");
                string = stringBuilder.append(this.escape(string2)).append("</font>").toString();
            } else {
                String string3 = lexer2.getTokenText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"lexer.tokenText");
                string = this.escape(string3);
            }
            String current = string;
            html.append(current);
            lexer2.advance();
        }
        String string = html.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"html.toString()");
        return string;
    }

    private final String toHex(@NotNull Color $this$toHex) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%02x%02x%02x";
        Object[] objectArray = new Object[]{$this$toHex.getRed(), $this$toHex.getGreen(), $this$toHex.getBlue()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private final String escape(String html) {
        return EntityConverter.INSTANCE.replaceEntities((CharSequence)html, true, true);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0019B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult;", "", "html", "Ljava/lang/ref/SoftReference;", "", "expires", "", "(Ljava/lang/ref/SoftReference;J)V", "getExpires", "()J", "setExpires", "(J)V", "getHtml", "()Ljava/lang/ref/SoftReference;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "resolve", "Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult$HTMLResult;", "toString", "HTMLResult", "intellij.markdown"})
    private static final class CachedHTMLResult {
        @NotNull
        private final SoftReference<String> html;
        private long expires;

        @Nullable
        public final HTMLResult resolve() {
            HTMLResult hTMLResult;
            String string = this.html.get();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                hTMLResult = new HTMLResult(string3, this.expires);
            } else {
                hTMLResult = null;
            }
            return hTMLResult;
        }

        @NotNull
        public final SoftReference<String> getHtml() {
            return this.html;
        }

        public final long getExpires() {
            return this.expires;
        }

        public final void setExpires(long l) {
            this.expires = l;
        }

        public CachedHTMLResult(@NotNull SoftReference<String> html, long expires) {
            Intrinsics.checkParameterIsNotNull(html, (String)"html");
            this.html = html;
            this.expires = expires;
        }

        @NotNull
        public final SoftReference<String> component1() {
            return this.html;
        }

        public final long component2() {
            return this.expires;
        }

        @NotNull
        public final CachedHTMLResult copy(@NotNull SoftReference<String> html, long expires) {
            Intrinsics.checkParameterIsNotNull(html, (String)"html");
            return new CachedHTMLResult(html, expires);
        }

        public static /* synthetic */ CachedHTMLResult copy$default(CachedHTMLResult cachedHTMLResult, SoftReference softReference, long l, int n, Object object) {
            if ((n & 1) != 0) {
                softReference = cachedHTMLResult.html;
            }
            if ((n & 2) != 0) {
                l = cachedHTMLResult.expires;
            }
            return cachedHTMLResult.copy(softReference, l);
        }

        @NotNull
        public String toString() {
            return "CachedHTMLResult(html=" + this.html + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            SoftReference<String> softReference = this.html;
            return (softReference != null ? softReference.hashCode() : 0) * 31 + Long.hashCode(this.expires);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CachedHTMLResult)) break block3;
                    CachedHTMLResult cachedHTMLResult = (CachedHTMLResult)object;
                    if (!Intrinsics.areEqual(this.html, cachedHTMLResult.html) || this.expires != cachedHTMLResult.expires) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter$CachedHTMLResult$HTMLResult;", "", "html", "", "expires", "", "(Ljava/lang/String;J)V", "getExpires", "()J", "getHtml", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown"})
        public static final class HTMLResult {
            @NotNull
            private final String html;
            private final long expires;

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            public final long getExpires() {
                return this.expires;
            }

            public HTMLResult(@NotNull String html, long expires) {
                Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
                this.html = html;
                this.expires = expires;
            }

            @NotNull
            public final String component1() {
                return this.html;
            }

            public final long component2() {
                return this.expires;
            }

            @NotNull
            public final HTMLResult copy(@NotNull String html, long expires) {
                Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
                return new HTMLResult(html, expires);
            }

            public static /* synthetic */ HTMLResult copy$default(HTMLResult hTMLResult, String string, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    string = hTMLResult.html;
                }
                if ((n & 2) != 0) {
                    l = hTMLResult.expires;
                }
                return hTMLResult.copy(string, l);
            }

            @NotNull
            public String toString() {
                return "HTMLResult(html=" + this.html + ", expires=" + this.expires + ")";
            }

            public int hashCode() {
                String string = this.html;
                return (string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.expires);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HTMLResult)) break block3;
                        HTMLResult hTMLResult = (HTMLResult)object;
                        if (!Intrinsics.areEqual((Object)this.html, (Object)hTMLResult.html) || this.expires != hTMLResult.expires) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/highlighter/MarkdownCodeFencePreviewHighlighter$Companion;", "", "()V", "expiration", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

