/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFinder {
    private final List<String> classNameList = new ArrayList<String>();
    private final int startPackageName;
    private final boolean includeUnconventionallyNamedTests;

    public ClassFinder(File classPathRoot, String rootPackage, boolean includeUnconventionallyNamedTests) {
        this.includeUnconventionallyNamedTests = includeUnconventionallyNamedTests;
        this.startPackageName = classPathRoot.getAbsolutePath().length() + 1;
        String directoryOffset = rootPackage.replace('.', File.separatorChar);
        this.findAndStoreTestClasses(new File(classPathRoot, directoryOffset));
    }

    @Nullable
    private String computeClassName(File file2) {
        String absPath = file2.getAbsolutePath();
        if (!this.includeUnconventionallyNamedTests) {
            if (absPath.endsWith("Test.class")) {
                return StringUtil.trimEnd((String)absPath.substring(this.startPackageName), (String)".class").replace(File.separatorChar, '.');
            }
        } else {
            String nestedClassName = file2.getName();
            if (!nestedClassName.endsWith(".class")) {
                return null;
            }
            nestedClassName = StringUtil.trimEnd((String)nestedClassName, (String)".class");
            List<String> names = Arrays.asList(nestedClassName.split("\\$"));
            Collections.reverse(names);
            for (String className : names) {
                if (!Character.isUpperCase(className.charAt(0))) {
                    return null;
                }
                List<String> words = Arrays.asList(NameUtilCore.nameToWords((String)className));
                if (!words.contains("Test") && !words.contains("Tests") && !words.contains("Suite")) continue;
                String fqn = StringUtil.trimEnd((String)absPath.substring(this.startPackageName), (String)".class").replace(File.separatorChar, '.');
                if (Arrays.asList("com.intellij.tests.BootstrapTests", "com.intellij.AllTests").contains(fqn)) continue;
                return fqn;
            }
        }
        return null;
    }

    private void findAndStoreTestClasses(@NotNull File current) {
        if (current == null) {
            ClassFinder.$$$reportNull$$$0(0);
        }
        if (current.isDirectory()) {
            File[] files = current.listFiles();
            if (files != null) {
                for (File file2 : files) {
                    this.findAndStoreTestClasses(file2);
                }
            }
        } else {
            ContainerUtil.addIfNotNull(this.classNameList, (Object)this.computeClassName(current));
        }
    }

    public Collection<String> getClasses() {
        return this.classNameList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/ClassFinder", "findAndStoreTestClasses"));
    }
}

