/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.InstallPluginService;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\"\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/ide/InstallPluginService;", "Lorg/jetbrains/ide/RestService;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isAvailable", "", "()Z", "setAvailable", "(Z)V", "checkCompatibility", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "pluginId", "", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getServiceName", "installPlugin", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "isHostTrusted", "productInfo", "writeIDEInfo", "", "out", "Ljava/io/OutputStream;", "intellij.platform.builtInServer.impl"})
public final class InstallPluginService
extends RestService {
    private final Logger LOG;
    private boolean isAvailable;

    @Override
    @NotNull
    protected String getServiceName() {
        return "installPlugin";
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return true;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    public final void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                pluginId = RestService.Companion.getStringParameter("pluginId", urlDecoder);
                action = RestService.Companion.getStringParameter("action", urlDecoder);
                var6_6 = pluginId;
                var7_7 = false;
                var8_8 = false;
                if (var6_6 == null || StringsKt.isBlank((CharSequence)var6_6) != false) {
                    return (String)this.productInfo(request, context);
                }
                v0 = action;
                if (v0 == null) break block5;
                var6_6 = v0;
                switch (var6_6.hashCode()) {
                    case 1957569947: {
                        if (!var6_6.equals("install")) ** break;
                        break;
                    }
                    case -1762427576: {
                        if (!var6_6.equals("checkCompatibility")) ** break;
                        v1 = (String)this.checkCompatibility(request, context, pluginId);
                        break block6;
                    }
                }
                v1 = (String)this.installPlugin(request, context, pluginId);
                break block6;
            }
            v1 = (String)this.productInfo(request, context);
        }
        return v1;
    }

    private final Void checkCompatibility(FullHttpRequest request, ChannelHandlerContext context, String pluginId) {
        boolean compatibleUpdateExists = MarketplaceRequests.getLastCompatiblePluginUpdate$default((MarketplaceRequests)MarketplaceRequests.Companion.getInstance(), (String)pluginId, null, null, (int)6, null) != null;
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        JsonWriter writer = RestService.Companion.createJsonWriter((OutputStream)out);
        writer.beginObject();
        writer.name("compatible").value(compatibleUpdateExists);
        writer.endObject();
        writer.close();
        RestService.Companion.send(out, (HttpRequest)request, context);
        return null;
    }

    private final Void installPlugin(FullHttpRequest request, ChannelHandlerContext context, String pluginId) {
        PluginId pluginId2 = PluginId.findId((String[])new String[]{pluginId});
        if (pluginId2 != null) {
            PluginId pluginId3 = pluginId2;
            boolean bl = false;
            boolean bl2 = false;
            PluginId it = pluginId3;
            boolean bl3 = false;
            if (this.isAvailable) {
                this.isAvailable = false;
                Project project = RestService.Companion.getLastFocusedOrOpenedProject();
                if (project == null) {
                    ProjectManager projectManager = ProjectManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
                    Project project2 = projectManager.getDefaultProject();
                    project = project2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"ProjectManager.getInstance().defaultProject");
                }
                Project effectiveProject = project;
                ApplicationManager.getApplication().invokeLater(new Runnable(effectiveProject, it, this){
                    final /* synthetic */ Project $effectiveProject;
                    final /* synthetic */ PluginId $it;
                    final /* synthetic */ InstallPluginService this$0;
                    {
                        this.$effectiveProject = project;
                        this.$it = pluginId;
                        this.this$0 = installPluginService;
                    }

                    public final void run() {
                        AppIcon.getInstance().requestAttention(this.$effectiveProject, true);
                        PluginsAdvertiser.installAndEnable((Set)SetsKt.setOf((Object)this.$it), (Runnable)installPlugin.1.1.INSTANCE);
                        this.this$0.setAvailable(true);
                    }
                }, effectiveProject.getDisposed());
            }
        }
        RestService.Companion.sendOk(request, context);
        return null;
    }

    private final Void productInfo(FullHttpRequest request, ChannelHandlerContext context) {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        this.writeIDEInfo((OutputStream)out);
        RestService.Companion.send(out, (HttpRequest)request, context);
        return null;
    }

    private final void writeIDEInfo(OutputStream out) {
        JsonWriter writer = RestService.Companion.createJsonWriter(out);
        writer.beginObject();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoEx.getInstanceEx()");
        String appName = applicationInfoEx.getFullApplicationName();
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        BuildNumber build = buildNumber;
        if (!PlatformUtils.isIdeaUltimate()) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = applicationNamesInfo.getProductName();
            String string = appName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appName");
            String string2 = productName + " (" + productName + ')';
            String string3 = productName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"productName");
            appName = StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
            appName = StringUtil.trimStart((String)appName, (String)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("buildNumber").value(build.asString());
        writer.endObject();
        writer.close();
    }

    @Override
    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        String origin = NettyKt.getOrigin((HttpRequest)((HttpRequest)request));
        try {
            string = origin == null ? null : StringKt.nullize$default((String)new URI(origin).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String originHost = string;
        String hostName = NettyKt.getHostName((HttpRequest)((HttpRequest)request));
        if (hostName != null && !NetUtils.isLocalhost((String)hostName)) {
            this.LOG.error("Expected 'request.hostName' to be localhost. hostName='" + hostName + "', origin='" + origin + '\'');
        }
        return originHost != null && (CollectionsKt.listOf((Object[])new String[]{"plugins.jetbrains.com", "package-search.services.jetbrains.com", "package-search.jetbrains.com"}).contains(originHost) || StringsKt.endsWith$default((String)originHost, (String)".dev.marketplace.intellij.net", (boolean)false, (int)2, null) || NetUtils.isLocalhost((String)originHost)) || super.isHostTrusted(request, urlDecoder);
    }

    public InstallPluginService() {
        Logger logger;
        InstallPluginService installPluginService = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(InstallPluginService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        installPluginService.LOG = logger = logger2;
        this.isAvailable = true;
    }
}

