/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableModel;
import com.intellij.openapi.externalSystem.service.project.ModifiableWorkspace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.TestModuleProperties;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    private ModifiableModuleModel myModifiableModuleModel;
    private final Map<Module, ModifiableRootModel> myModifiableRootModels;
    private final Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    private final Map<Module, String> myProductionModulesForTestModules;
    private final Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    private final ClassMap<ModifiableModel> myModifiableModels;
    @Nullable
    private ModifiableWorkspace myModifiableWorkspace;
    private final MyUserDataHolderBase myUserData;
    private volatile boolean myDisposed;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModifiableRootModels = new THashMap();
        this.myModifiableFacetModels = new THashMap();
        this.myProductionModulesForTestModules = new THashMap();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myModifiableModels = new ClassMap();
        this.myUserData = new MyUserDataHolderBase();
        EP_NAME.forEachExtensionSafe(extension -> {
            Pair pair = extension.create(project, (IdeModifiableModelsProvider)this);
            this.myModifiableModels.put((Class)pair.first, (Object)((ModifiableModel)pair.second));
        });
    }

    @Nullable
    public <T extends ModifiableModel> T findModifiableModel(@NotNull Class<T> instanceOf) {
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(1);
        }
        return (T)((ModifiableModel)ObjectUtils.tryCast((Object)this.myModifiableModels.get(instanceOf), instanceOf));
    }

    @NotNull
    public <T extends ModifiableModel> T getModifiableModel(@NotNull Class<T> instanceOf) {
        ModifiableModel model;
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(2);
        }
        if (instanceOf.isInstance(model = (ModifiableModel)this.myModifiableModels.get(instanceOf))) {
            ModifiableModel modifiableModel = (ModifiableModel)instanceOf.cast(model);
            if (modifiableModel == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(3);
            }
            return (T)modifiableModel;
        }
        throw new AssertionError((Object)String.format("Unable to get `%s` model", instanceOf.getSimpleName()));
    }

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    public Module @NotNull [] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    @Override
    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(5);
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module).getOrderEntries();
        if (orderEntryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(6);
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(7);
        }
        Module module = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        if (!module.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module.setModuleType(moduleTypeId);
        Module module2 = module;
        if (module2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(8);
        }
        return module2;
    }

    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(9);
        }
        String imlName = null;
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module = this.findIdeModule(candidate);
            if (module != null) continue;
            imlName = candidate;
            break;
        }
        assert (imlName != null) : "Too many duplicated module names";
        String filePath = ExternalSystemApiUtil.toCanonicalPath((String)(moduleData.getModuleFileDirectoryPath() + "/" + imlName + ".iml"));
        Module module = this.newModule(filePath, moduleData.getModuleTypeId());
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(10);
        }
        return module;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module;
        if (ideModuleName == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(11);
        }
        return (module = this.getModifiableModuleModel().findModuleByName(ideModuleName)) == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(12);
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    public VirtualFile @NotNull [] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getContentRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(13);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(14);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(16);
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module) {
        return (ModifiableRootModel)this.getRootModel(module);
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module) {
        ModuleRootModel moduleRootModel = (ModuleRootModel)this.myModifiableRootModels.computeIfAbsent(module, k -> this.doGetModifiableRootModel(module));
        if (moduleRootModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(17);
        }
        return moduleRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module) {
        ModifiableFacetModel modifiableFacetModel = this.myModifiableFacetModels.computeIfAbsent(module, k -> this.doGetModifiableFacetModel(module));
        if (modifiableFacetModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(18);
        }
        return modifiableFacetModel;
    }

    @Override
    public Library @NotNull [] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(19);
        }
        return libraryArray;
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public Library createLibrary(String name, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name, null, externalSource);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Nullable
    public ModifiableWorkspace getModifiableWorkspace() {
        if (this.myModifiableWorkspace == null && ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
            this.myModifiableWorkspace = this.doGetModifiableWorkspace();
        }
        return this.myModifiableWorkspace;
    }

    @Override
    public String @NotNull [] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model;
        if (library == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(20);
        }
        if (type == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(21);
        }
        if ((model = this.myModifiableLibraryModels.get(library)) != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(22);
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(24);
        }
        ArrayList<Module> list2 = new ArrayList<Module>();
        Graph<Module> graph2 = this.getModuleGraph();
        Iterator i2 = graph2.getOut((Object)module);
        while (i2.hasNext()) {
            list2.add((Module)i2.next());
        }
        ArrayList<Module> arrayList = list2;
        if (arrayList == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private ModifiableWorkspace doGetModifiableWorkspace() {
        return (ModifiableWorkspace)ReadAction.compute(() -> ((ExternalProjectsWorkspaceImpl)ServiceManager.getService((Project)this.myProject, ExternalProjectsWorkspaceImpl.class)).createModifiableWorkspace(this));
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            @NotNull
            public Collection<Module> getNodes() {
                List<Module> list2 = Arrays.asList(AbstractIdeModifiableModelsProvider.this.getModules());
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @NotNull
            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                Iterator<Module> iterator2 = Arrays.asList(dependentModules).iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    public void commit() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            if (ExternalProjectsWorkspaceImpl.isDependencySubstitutionEnabled()) {
                this.updateSubstitutions();
            }
            for (Map.Entry<Library, Library.ModifiableModel> entry : this.myModifiableLibraryModels.entrySet()) {
                Library fromLibrary = entry.getKey();
                Library.ModifiableModel modifiableModel = entry.getValue();
                if (fromLibrary instanceof LibraryEx && ((LibraryEx)fromLibrary).isDisposed()) {
                    Disposer.dispose((Disposable)modifiableModel);
                    continue;
                }
                modifiableModel.commit();
            }
            this.getModifiableProjectLibrariesModel().commit();
            Collection<ModifiableRootModel> rootModels = this.myModifiableRootModels.values();
            ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[0]);
            for (Object model : rootModels1) {
                assert (!model.isDisposed()) : "Already disposed: " + model;
            }
            if (this.myModifiableModuleModel != null) {
                ModifiableModelCommitter.multiCommit(rootModels1, this.myModifiableModuleModel);
            } else {
                for (Object model : rootModels1) {
                    model.commit();
                }
            }
            for (Map.Entry entry : this.myProductionModulesForTestModules.entrySet()) {
                TestModuleProperties.getInstance((Module)entry.getKey()).setProductionModuleName((String)entry.getValue());
            }
            for (Map.Entry entry : this.myModifiableFacetModels.entrySet()) {
                if (((Module)entry.getKey()).isDisposed()) continue;
                ((ModifiableFacetModel)entry.getValue()).commit();
            }
            this.myModifiableModels.values().forEach(ModifiableModel::commit);
        });
        this.myUserData.clear();
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (!this.myDisposed) : "Already disposed!";
        this.myDisposed = true;
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)modifiableModel).isDisposed()) continue;
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null && this.myModifiableModuleModel.isChanged()) {
            this.myModifiableModuleModel.dispose();
        }
        this.myModifiableModels.values().forEach(ModifiableModel::dispose);
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Nullable
    public String getProductionModuleName(Module module) {
        return this.myProductionModulesForTestModules.get(module);
    }

    public ModuleOrderEntry trySubstitute(Module ownerModule, LibraryOrderEntry libraryOrderEntry, ProjectCoordinate publicationId) {
        Module workspaceModule;
        String workspaceModuleCandidate = this.findModuleByPublication(publicationId);
        Module module = workspaceModule = workspaceModuleCandidate == null ? null : this.findIdeModule(workspaceModuleCandidate);
        if (workspaceModule == null) {
            return null;
        }
        ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(ownerModule);
        ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(workspaceModule);
        moduleOrderEntry.setScope(libraryOrderEntry.getScope());
        moduleOrderEntry.setExported(libraryOrderEntry.isExported());
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        assert (workspace != null);
        workspace.addSubstitution(ownerModule.getName(), workspaceModule.getName(), libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
        modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
        return moduleOrderEntry;
    }

    public void registerModulePublication(Module module, ProjectCoordinate modulePublication) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace != null) {
            workspace.register(modulePublication, module);
        }
    }

    public boolean isSubstituted(String libraryName) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.isSubstituted(libraryName);
    }

    @Nullable
    public <T> T getUserData(@NotNull com.intellij.openapi.util.Key<T> key) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(26);
        }
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull com.intellij.openapi.util.Key<T> key, @Nullable T value2) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(27);
        }
        this.myUserData.putUserData(key, value2);
    }

    @Nullable
    public String findModuleByPublication(ProjectCoordinate publicationId) {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        return workspace == null ? null : workspace.findModule(publicationId);
    }

    private void updateSubstitutions() {
        ModifiableWorkspace workspace = this.getModifiableWorkspace();
        if (workspace == null) {
            return;
        }
        List oldModules = ContainerUtil.map((Object[])ModuleManager.getInstance((Project)this.myProject).getModules(), module -> module.getName());
        List newModules = ContainerUtil.map((Object[])this.myModifiableModuleModel.getModules(), module -> module.getName());
        THashSet removedModules = new THashSet((Collection)oldModules);
        removedModules.removeAll(newModules);
        HashMap<String, String> toSubstitute = new HashMap<String, String>();
        ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            Collection projectsData = projectDataManager.getExternalProjectsData(this.myProject, manager.getSystemId());
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null) continue;
                Collection libraryNodes = ExternalSystemApiUtil.findAll((DataNode)projectInfo.getExternalProjectStructure(), (Key)ProjectKeys.LIBRARY);
                for (DataNode libraryNode : libraryNodes) {
                    String substitutionModuleCandidate = this.findModuleByPublication((ProjectCoordinate)libraryNode.getData());
                    if (substitutionModuleCandidate == null) continue;
                    toSubstitute.put(((LibraryData)libraryNode.getData()).getInternalName(), substitutionModuleCandidate);
                }
            }
        }
        for (Module module2 : this.getModules()) {
            ModifiableRootModel modifiableRootModel = this.getModifiableRootModel(module2);
            boolean changed2 = false;
            OrderEntry[] entries = modifiableRootModel.getOrderEntries();
            int length = entries.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Module ideModule;
                String workspaceModule;
                LibraryOrderEntry libraryOrderEntry;
                String workspaceModule2;
                OrderEntry orderEntry = entries[i2];
                if (orderEntry instanceof ModuleOrderEntry && removedModules.contains(workspaceModule2 = ((ModuleOrderEntry)orderEntry).getModuleName())) {
                    Library library;
                    String libraryName;
                    DependencyScope scope = ((ModuleOrderEntry)orderEntry).getScope();
                    if (workspace.isSubstitution(module2.getName(), workspaceModule2, scope) && (libraryName = workspace.getSubstitutedLibrary(workspaceModule2)) != null && (library = this.getLibraryByName(libraryName)) != null) {
                        modifiableRootModel.removeOrderEntry(orderEntry);
                        entries[i2] = modifiableRootModel.addLibraryEntry(library);
                        changed2 = true;
                        workspace.removeSubstitution(module2.getName(), workspaceModule2, libraryName, scope);
                    }
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || libraryOrderEntry.getLibraryName() == null || (workspaceModule = (String)toSubstitute.get(libraryOrderEntry.getLibraryName())) == null || (ideModule = this.findIdeModule(workspaceModule)) == null) continue;
                ModuleOrderEntry moduleOrderEntry = modifiableRootModel.addModuleOrderEntry(ideModule);
                moduleOrderEntry.setScope(libraryOrderEntry.getScope());
                modifiableRootModel.removeOrderEntry(orderEntry);
                entries[i2] = moduleOrderEntry;
                changed2 = true;
                workspace.addSubstitution(module2.getName(), workspaceModule, libraryOrderEntry.getLibraryName(), libraryOrderEntry.getScope());
            }
            if (!changed2) continue;
            modifiableRootModel.rearrangeOrderEntries(entries);
        }
        workspace.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModuleModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableFacetModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModifiableModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModel";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUserDataHolderBase
    extends UserDataHolderBase {
        private MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

