/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.DynamicBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BrowserSettingsPanel {
    private static final FileChooserDescriptor APP_FILE_CHOOSER_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String> PATH_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>(IdeBundle.message((String)"settings.browsers.column.path", (Object[])new Object[0])){

        public String valueOf(ConfigurableWebBrowser item) {
            return PathUtil.toSystemDependentName((String)item.getPath());
        }

        public void setValue(ConfigurableWebBrowser item, String value2) {
            item.setPath(value2);
        }

        @Nullable
        public TableCellEditor getEditor(ConfigurableWebBrowser item) {
            return new LocalPathCellEditor().fileChooserDescriptor(APP_FILE_CHOOSER_DESCRIPTOR).normalizePath(true);
        }
    };
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean> ACTIVE_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean>(){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(ConfigurableWebBrowser item) {
            return item.isActive();
        }

        public void setValue(ConfigurableWebBrowser item, Boolean value2) {
            item.setActive(value2);
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{ACTIVE_COLUMN_INFO, new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>(IdeBundle.message((String)"settings.browsers.column.name", (Object[])new Object[0])){

        public String valueOf(ConfigurableWebBrowser item) {
            return item.getName();
        }

        public void setValue(ConfigurableWebBrowser item, String value2) {
            item.setName(value2);
        }
    }, new ColumnInfo<ConfigurableWebBrowser, BrowserFamily>(IdeBundle.message((String)"settings.browsers.column.family", (Object[])new Object[0])){

        public Class getColumnClass() {
            return BrowserFamily.class;
        }

        public BrowserFamily valueOf(ConfigurableWebBrowser item) {
            return item.getFamily();
        }

        public void setValue(ConfigurableWebBrowser item, BrowserFamily value2) {
            item.setFamily(value2);
            item.setSpecificSettings(value2.createBrowserSpecificSettings());
        }

        @NotNull
        public TableCellRenderer getRenderer(ConfigurableWebBrowser item) {
            IconTableCellRenderer<Iconable> iconTableCellRenderer = IconTableCellRenderer.ICONABLE;
            if (iconTableCellRenderer == null) {
                4.$$$reportNull$$$0(0);
            }
            return iconTableCellRenderer;
        }

        public boolean isCellEditable(ConfigurableWebBrowser item) {
            return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserSettingsPanel$4", "getRenderer"));
        }
    }, PATH_COLUMN_INFO};
    private JPanel root;
    private TextFieldWithBrowseButton alternativeBrowserPathField;
    private JPanel defaultBrowserPanel;
    private JComponent browsersTable;
    private ComboBox<DefaultBrowserPolicy> defaultBrowserPolicyComboBox;
    private JBCheckBox showBrowserHover;
    private JBCheckBox showBrowserHoverXml;
    private JPanel browserPopupPanel;
    private TableModelEditor<ConfigurableWebBrowser> browsersEditor;
    private String customPathValue;

    BrowserSettingsPanel() {
        this.$$$setupUI$$$();
        this.alternativeBrowserPathField.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, APP_FILE_CHOOSER_DESCRIPTOR);
        this.defaultBrowserPanel.setBorder(TitledSeparator.createEmptyBorder());
        ArrayList<DefaultBrowserPolicy> defaultBrowserPolicies = new ArrayList<DefaultBrowserPolicy>();
        if (BrowserLauncherAppless.canUseSystemDefaultBrowserPolicy()) {
            defaultBrowserPolicies.add(DefaultBrowserPolicy.SYSTEM);
        }
        defaultBrowserPolicies.add(DefaultBrowserPolicy.FIRST);
        defaultBrowserPolicies.add(DefaultBrowserPolicy.ALTERNATIVE);
        this.defaultBrowserPolicyComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(defaultBrowserPolicies));
        this.defaultBrowserPolicyComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                boolean customPathEnabled;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                boolean bl = customPathEnabled = e.getItem() == DefaultBrowserPolicy.ALTERNATIVE;
                if (e.getStateChange() == 2) {
                    if (customPathEnabled) {
                        BrowserSettingsPanel.this.customPathValue = BrowserSettingsPanel.this.alternativeBrowserPathField.getText();
                    }
                } else if (e.getStateChange() == 1) {
                    BrowserSettingsPanel.this.alternativeBrowserPathField.setEnabled(customPathEnabled);
                    BrowserSettingsPanel.this.updateCustomPathTextFieldValue((DefaultBrowserPolicy)((Object)e.getItem()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/BrowserSettingsPanel$5", "itemStateChanged"));
            }
        });
        this.defaultBrowserPolicyComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value2 -> {
            String text;
            String string = value2 == DefaultBrowserPolicy.SYSTEM ? IdeBundle.message((String)"settings.browsers.system.default", (Object[])new Object[0]) : (value2 == DefaultBrowserPolicy.FIRST ? IdeBundle.message((String)"settings.browsers.first.listed", (Object[])new Object[0]) : (text = value2 == DefaultBrowserPolicy.ALTERNATIVE ? IdeBundle.message((String)"settings.browsers.custom.path", (Object[])new Object[0]) : null));
            if (text == null) {
                throw new IllegalStateException(String.valueOf(value2));
            }
            return text;
        }));
        this.browserPopupPanel.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"settings.browsers.show.browser.popup.in.the.editor", (Object[])new Object[0])));
    }

    private void updateCustomPathTextFieldValue(@NotNull DefaultBrowserPolicy browser2) {
        if (browser2 == null) {
            BrowserSettingsPanel.$$$reportNull$$$0(0);
        }
        if (browser2 == DefaultBrowserPolicy.ALTERNATIVE) {
            this.alternativeBrowserPathField.setText(this.customPathValue);
        } else if (browser2 == DefaultBrowserPolicy.FIRST) {
            this.setCustomPathToFirstListed();
        } else {
            this.alternativeBrowserPathField.setText("");
        }
    }

    private void createUIComponents() {
        TableModelEditor.DialogItemEditor<ConfigurableWebBrowser> itemEditor = new TableModelEditor.DialogItemEditor<ConfigurableWebBrowser>(){

            @Override
            @NotNull
            public Class<ConfigurableWebBrowser> getItemClass() {
                return ConfigurableWebBrowser.class;
            }

            @Override
            public ConfigurableWebBrowser clone(@NotNull ConfigurableWebBrowser item, boolean forInPlaceEditing) {
                if (item == null) {
                    6.$$$reportNull$$$0(0);
                }
                return new ConfigurableWebBrowser(forInPlaceEditing ? item.getId() : UUID.randomUUID(), item.getFamily(), item.getName(), item.getPath(), item.isActive(), forInPlaceEditing ? item.getSpecificSettings() : this.cloneSettings(item));
            }

            @Override
            public void edit(@NotNull ConfigurableWebBrowser browser2, @NotNull Function<ConfigurableWebBrowser, ConfigurableWebBrowser> mutator, boolean isAdd) {
                BrowserSpecificSettings settings;
                if (browser2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (mutator == null) {
                    6.$$$reportNull$$$0(2);
                }
                if ((settings = this.cloneSettings(browser2)) != null && ShowSettingsUtil.getInstance().editConfigurable((Component)BrowserSettingsPanel.this.browsersTable, settings.createConfigurable())) {
                    ((ConfigurableWebBrowser)((Object)mutator.fun((Object)browser2))).setSpecificSettings(settings);
                }
            }

            @Nullable
            private BrowserSpecificSettings cloneSettings(@NotNull ConfigurableWebBrowser browser2) {
                BrowserSpecificSettings settings;
                if (browser2 == null) {
                    6.$$$reportNull$$$0(3);
                }
                if ((settings = browser2.getSpecificSettings()) == null) {
                    return null;
                }
                BrowserSpecificSettings newSettings = browser2.getFamily().createBrowserSpecificSettings();
                assert (newSettings != null);
                TableModelEditor.cloneUsingXmlSerialization(settings, newSettings);
                return newSettings;
            }

            @Override
            public void applyEdited(@NotNull ConfigurableWebBrowser oldItem, @NotNull ConfigurableWebBrowser newItem) {
                if (oldItem == null) {
                    6.$$$reportNull$$$0(4);
                }
                if (newItem == null) {
                    6.$$$reportNull$$$0(5);
                }
                oldItem.setSpecificSettings(newItem.getSpecificSettings());
            }

            @Override
            public boolean isEditable(@NotNull ConfigurableWebBrowser browser2) {
                if (browser2 == null) {
                    6.$$$reportNull$$$0(6);
                }
                return browser2.getSpecificSettings() != null;
            }

            @Override
            public boolean isRemovable(@NotNull ConfigurableWebBrowser item) {
                if (item == null) {
                    6.$$$reportNull$$$0(7);
                }
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "browser";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mutator";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldItem";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/browsers/BrowserSettingsPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "clone";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "edit";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cloneSettings";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyEdited";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEditable";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isRemovable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.browsersEditor = new TableModelEditor<ConfigurableWebBrowser>(COLUMNS, itemEditor, IdeBundle.message((String)"settings.browsers.no.web.browsers.configured", (Object[])new Object[0])).modelListener(new TableModelEditor.DataChangedListener<ConfigurableWebBrowser>(){

            @Override
            public void tableChanged(@NotNull TableModelEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.update();
            }

            @Override
            public void dataChanged(@NotNull ColumnInfo<ConfigurableWebBrowser, ?> columnInfo, int rowIndex) {
                if (columnInfo == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (columnInfo == PATH_COLUMN_INFO || columnInfo == ACTIVE_COLUMN_INFO) {
                    this.update();
                }
            }

            private void update() {
                if (BrowserSettingsPanel.this.getDefaultBrowser() == DefaultBrowserPolicy.FIRST) {
                    BrowserSettingsPanel.this.setCustomPathToFirstListed();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columnInfo";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/browsers/BrowserSettingsPanel$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tableChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.browsersTable = this.browsersEditor.createComponent();
    }

    private void setCustomPathToFirstListed() {
        ListTableModel<ConfigurableWebBrowser> model = this.browsersEditor.getModel();
        int n = model.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            ConfigurableWebBrowser browser2 = (ConfigurableWebBrowser)((Object)model.getRowValue(i2));
            if (!browser2.isActive() || browser2.getPath() == null) continue;
            this.alternativeBrowserPathField.setText(browser2.getPath());
            return;
        }
        this.alternativeBrowserPathField.setText("");
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel2 = this.root;
        if (jPanel2 == null) {
            BrowserSettingsPanel.$$$reportNull$$$0(1);
        }
        return jPanel2;
    }

    public boolean isModified() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        DefaultBrowserPolicy defaultBrowserPolicy = this.getDefaultBrowser();
        if (BrowserSettingsPanel.getDefaultBrowserPolicy(browserManager) != defaultBrowserPolicy || browserManager.isShowBrowserHover() != this.showBrowserHover.isSelected() || browserManager.isShowBrowserHoverXml() != this.showBrowserHoverXml.isSelected()) {
            return true;
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE && !Comparing.strEqual((String)generalSettings.getBrowserPath(), (String)this.alternativeBrowserPathField.getText())) {
            return true;
        }
        return this.browsersEditor.isModified();
    }

    public void apply() {
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setUseDefaultBrowser(this.getDefaultBrowser() == DefaultBrowserPolicy.SYSTEM);
        if (this.alternativeBrowserPathField.isEnabled()) {
            settings.setBrowserPath(this.alternativeBrowserPathField.getText());
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        browserManager.setShowBrowserHover(this.showBrowserHover.isSelected());
        browserManager.setShowBrowserHoverXml(this.showBrowserHoverXml.isSelected());
        browserManager.defaultBrowserPolicy = this.getDefaultBrowser();
        browserManager.setList(this.browsersEditor.apply());
    }

    private DefaultBrowserPolicy getDefaultBrowser() {
        return (DefaultBrowserPolicy)((Object)this.defaultBrowserPolicyComboBox.getSelectedItem());
    }

    public void reset() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        DefaultBrowserPolicy effectiveDefaultBrowserPolicy = BrowserSettingsPanel.getDefaultBrowserPolicy(browserManager);
        this.defaultBrowserPolicyComboBox.setSelectedItem((Object)effectiveDefaultBrowserPolicy);
        GeneralSettings settings = GeneralSettings.getInstance();
        this.showBrowserHover.setSelected(browserManager.isShowBrowserHover());
        this.showBrowserHoverXml.setSelected(browserManager.isShowBrowserHoverXml());
        this.browsersEditor.reset(browserManager.getList());
        this.customPathValue = settings.getBrowserPath();
        this.alternativeBrowserPathField.setEnabled(effectiveDefaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE);
        this.updateCustomPathTextFieldValue(effectiveDefaultBrowserPolicy);
    }

    private static DefaultBrowserPolicy getDefaultBrowserPolicy(WebBrowserManager manager) {
        DefaultBrowserPolicy policy = manager.getDefaultBrowserPolicy();
        if (policy != DefaultBrowserPolicy.SYSTEM || BrowserLauncherAppless.canUseSystemDefaultBrowserPolicy()) {
            return policy;
        }
        return DefaultBrowserPolicy.ALTERNATIVE;
    }

    public void selectBrowser(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            BrowserSettingsPanel.$$$reportNull$$$0(2);
        }
        if (browser2 instanceof ConfigurableWebBrowser) {
            this.browsersEditor.selectItem((ConfigurableWebBrowser)browser2);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        ComboBox comboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.root = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.defaultBrowserPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.alternativeBrowserPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.defaultBrowserPolicyComboBox = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", BrowserSettingsPanel.class).getString("settings.browsers.default.browser"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.browsersTable;
        jPanel4.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.browserPopupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IdeBundle", BrowserSettingsPanel.class).getString("settings.browsers.show.browser.popup.in.the.editor"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel2.getFont()), null));
        this.showBrowserHover = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/IdeBundle", BrowserSettingsPanel.class).getString("settings.browsers.show.browser.popup.html"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.showBrowserHoverXml = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", BrowserSettingsPanel.class).getString("settings.browsers.show.browser.popup.xml"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/BrowserSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/BrowserSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCustomPathTextFieldValue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectBrowser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

