/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.PythonFlavorProvider;
import icons.PythonSdkIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonSdkFlavor {
    public static final ExtensionPointName<PythonSdkFlavor> EP_NAME = ExtensionPointName.create((String)"Pythonid.pythonSdkFlavor");
    private static final Pattern VERSION_RE = Pattern.compile("(Python \\S+).*");
    private static final Logger LOG = Logger.getInstance(PythonSdkFlavor.class);

    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        Collection<String> collection = this.suggestHomePaths(module);
        if (collection == null) {
            PythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module) {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isApplicable() {
        return false;
    }

    public boolean isPlatformIndependent() {
        return false;
    }

    @Nullable
    public String envPathParam() {
        return null;
    }

    public static List<PythonSdkFlavor> getApplicableFlavors() {
        return PythonSdkFlavor.getApplicableFlavors(true);
    }

    public static List<PythonSdkFlavor> getApplicableFlavors(boolean addPlatformIndependent) {
        ArrayList<PythonSdkFlavor> result = new ArrayList<PythonSdkFlavor>();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isApplicable() && (!addPlatformIndependent || !flavor.isPlatformIndependent())) continue;
            result.add(flavor);
        }
        result.addAll(PythonSdkFlavor.getPlatformFlavorsFromExtensions(addPlatformIndependent));
        return result;
    }

    public static List<PythonSdkFlavor> getPlatformFlavorsFromExtensions(boolean isIndependent) {
        ArrayList<PythonSdkFlavor> result = new ArrayList<PythonSdkFlavor>();
        for (PythonFlavorProvider provider : PythonFlavorProvider.EP_NAME.getExtensionList()) {
            PythonSdkFlavor flavor = provider.getFlavor(isIndependent);
            if (flavor == null) continue;
            result.add(flavor);
        }
        return result;
    }

    public static List<PythonSdkFlavor> getPlatformIndependentFlavors() {
        ArrayList<PythonSdkFlavor> result = new ArrayList<PythonSdkFlavor>();
        for (PythonSdkFlavor flavor : EP_NAME.getExtensionList()) {
            if (!flavor.isPlatformIndependent()) continue;
            result.add(flavor);
        }
        return result;
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@NotNull Sdk sdk) {
        PythonSdkFlavor flavor;
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if ((data = sdk.getSdkAdditionalData()) instanceof PythonSdkAdditionalData && (flavor = ((PythonSdkAdditionalData)data).getFlavor()) != null) {
            return flavor;
        }
        return PythonSdkFlavor.getFlavor(sdk.getHomePath());
    }

    @Nullable
    public static PythonSdkFlavor getFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getApplicableFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    @Nullable
    public static PythonSdkFlavor getPlatformIndependentFlavor(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getPlatformIndependentFlavors()) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        for (PythonSdkFlavor flavor : PythonSdkFlavor.getPlatformFlavorsFromExtensions(true)) {
            if (!flavor.isValidSdkHome(sdkPath)) continue;
            return flavor;
        }
        return null;
    }

    public boolean isValidSdkHome(String path) {
        File file = new File(path);
        return file.isFile() && this.isValidSdkPath(file);
    }

    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            PythonSdkFlavor.$$$reportNull$$$0(3);
        }
        return StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)file.getName())).startsWith("python");
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        if (sdkHome == null) {
            return null;
        }
        String runDirectory = new File(sdkHome).getParent();
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(runDirectory, new String[]{sdkHome, this.getVersionOption()}, 10000);
        return this.getVersionStringFromOutput(processOutput);
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            PythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if (processOutput.getExitCode() != 0) {
            String errors = processOutput.getStderr();
            if (StringUtil.isEmpty((String)errors)) {
                errors = processOutput.getStdout();
            }
            LOG.warn("Couldn't get interpreter version: process exited with code " + processOutput.getExitCode() + "\n" + errors);
            return null;
        }
        String result = this.getVersionStringFromOutput(processOutput.getStderr());
        if (result != null) {
            return result;
        }
        return this.getVersionStringFromOutput(processOutput.getStdout());
    }

    @Nullable
    public String getVersionStringFromOutput(@NotNull String output) {
        if (output == null) {
            PythonSdkFlavor.$$$reportNull$$$0(5);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output)), (Pattern)VERSION_RE);
    }

    public String getVersionOption() {
        return "-V";
    }

    public Collection<String> getExtraDebugOptions() {
        return Collections.emptyList();
    }

    public void initPythonPath(GeneralCommandLine cmd, boolean passParentEnvs, Collection<String> path) {
        this.initPythonPath(path, passParentEnvs, cmd.getEnvironment());
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkFlavor.$$$reportNull$$$0(6);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(sdk.getVersionString());
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevel(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkFlavor.$$$reportNull$$$0(8);
        }
        LanguageLevel languageLevel = this.getLanguageLevelFromVersionString(this.getVersionString(sdkHome));
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(9);
        }
        return languageLevel;
    }

    @NotNull
    public LanguageLevel getLanguageLevelFromVersionString(@Nullable String version) {
        String prefix = this.getName() + " ";
        if (version != null && version.startsWith(prefix)) {
            LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(version.substring(prefix.length()));
            if (languageLevel == null) {
                PythonSdkFlavor.$$$reportNull$$$0(10);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkFlavor.$$$reportNull$$$0(11);
        }
        return languageLevel;
    }

    public Icon getIcon() {
        return PythonSdkIcons.Python;
    }

    public void initPythonPath(Collection<String> path, boolean passParentEnvs, Map<String, String> env) {
        PythonEnvUtil.initPythonPath(env, passParentEnvs, path);
    }

    public VirtualFile getSdkPath(VirtualFile path) {
        return path;
    }

    @Nullable
    public CommandLinePatcher commandLinePatcher() {
        return null;
    }

    public void dropCaches() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/PythonSdkFlavor";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelFromVersionString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFlavor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

