/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootScanner
implements AsyncVfsEventsListener {
    private static final Logger LOG = Logger.getInstance(VcsRootScanner.class);
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(0);
        }
        new VcsRootScanner(project).scheduleScan();
    }

    private VcsRootScanner(@NotNull Project project) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myProjectManager = ProjectRootManager.getInstance((Project)project);
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleScan(), (Disposable)project);
        VcsEP.EP_NAME.addChangeListener(() -> this.scheduleScan(), (Disposable)project);
    }

    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        List checkers;
        if (events == null) {
            VcsRootScanner.$$$reportNull$$$0(2);
        }
        if ((checkers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()).isEmpty()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !file.isDirectory()) continue;
            VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, file, dir -> {
                if (VcsRootScanner.isVcsDir(checkers, dir.getName())) {
                    this.scheduleScan();
                    return VirtualFileVisitor.skipTo((VirtualFile)file);
                }
                return VirtualFileVisitor.CONTINUE;
            });
        }
    }

    static void visitDirsRecursivelyWithoutExcluded(final @NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull VirtualFile root, final @NotNull Function<? super VirtualFile, ? extends VirtualFileVisitor.Result> dirFound) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(3);
        }
        if (projectRootManager == null) {
            VcsRootScanner.$$$reportNull$$$0(4);
        }
        if (root == null) {
            VcsRootScanner.$$$reportNull$$$0(5);
        }
        if (dirFound == null) {
            VcsRootScanner.$$$reportNull$$$0(6);
        }
        final ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFileVisitor.Option depthLimit = VirtualFileVisitor.limit((int)Registry.intValue((String)"vcs.root.detector.folder.depth"));
        final Pattern ignorePattern = VcsRootScanner.parseDirIgnorePattern();
        if (VcsRootScanner.isUnderIgnoredDirectory(project, ignorePattern, root)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, depthLimit}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory()) {
                    VirtualFileVisitor.Result result2 = CONTINUE;
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                if (VcsRootScanner.isIgnoredDirectory(project, ignorePattern, file)) {
                    VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                    if (result3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result3;
                }
                if (((Boolean)ReadAction.compute(() -> project.isDisposed() || !fileIndex.isInContent(file))).booleanValue()) {
                    VirtualFileVisitor.Result result4 = SKIP_CHILDREN;
                    if (result4 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result4;
                }
                VirtualFileVisitor.Result result5 = (VirtualFileVisitor.Result)dirFound.apply(file);
                if (result5 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return result5;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootScanner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootScanner$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean isVcsDir(@NotNull List<VcsRootChecker> checkers, @NotNull String filePath) {
        if (checkers == null) {
            VcsRootScanner.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            VcsRootScanner.$$$reportNull$$$0(8);
        }
        return checkers.stream().anyMatch(it -> it.isVcsDir(filePath));
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        if (VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList().isEmpty()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myAlarm, () -> this.myRootProblemNotifier.rescanAndNotifyIfNeeded()), WAIT_BEFORE_SCAN);
    }

    static boolean isUnderIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @NotNull VirtualFile dir) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            VcsRootScanner.$$$reportNull$$$0(10);
        }
        for (VirtualFile parent = dir; parent != null; parent = parent.getParent()) {
            if (!VcsRootScanner.isIgnoredDirectory(project, ignorePattern, parent)) continue;
            return true;
        }
        return false;
    }

    static boolean isIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @NotNull VirtualFile dir) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            VcsRootScanner.$$$reportNull$$$0(12);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).isIgnored(dir)) {
            LOG.debug("Skipping ignored dir: ", new Object[]{dir});
            return true;
        }
        if (ignorePattern != null && ignorePattern.matcher(dir.getName()).matches()) {
            LOG.debug("Skipping dir by pattern: ", new Object[]{dir});
            return true;
        }
        return false;
    }

    @Nullable
    static Pattern parseDirIgnorePattern() {
        try {
            return Pattern.compile(Registry.stringValue((String)"vcs.root.detector.ignore.pattern"));
        }
        catch (MissingResourceException | PatternSyntaxException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFound";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filesChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDirsRecursivelyWithoutExcluded";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isVcsDir";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderIgnoredDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

