from . import SimLibrary
from .. import SIM_PROCEDURES as P
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from ...sim_type import SimTypeFunction, SimTypeLong, SimTypeLongLong

lib = SimLibrary()
lib.set_library_names('kernel32.dll')
lib.add_all_from_dict(P['win32'])
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)

lib.add_alias('EncodePointer', 'DecodePointer')
lib.add_alias('GlobalAlloc', 'LocalAlloc')

lib.add('lstrcatA', P['libc']['strcat'])
lib.add('lstrcmpA', P['libc']['strcmp'])
lib.add('lstrcpyA', P['libc']['strcpy'])
lib.add('lstrcpynA', P['libc']['strncpy'])
lib.add('lstrlenA', P['libc']['strlen'])
lib.add('lstrcmpW', P['libc']['wcscmp'])
lib.add('lstrcmpiW', P['libc']['wcscasecmp'])

prototypes = {
    "AcquireSRWLockExclusive": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AcquireSRWLockShared": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ActivateActCtx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddAtomA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AddAtomW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AddConsoleAliasA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AddConsoleAliasW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AddIntegrityLabelToBoundaryDescriptor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddLocalAlternateComputerNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddLocalAlternateComputerNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddRefActCtx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AddSIDToBoundaryDescriptor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddSecureMemoryCacheCallback": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AddVectoredContinueHandler": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AddVectoredExceptionHandler": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AdjustCalendarDate": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AllocConsole": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "AllocateUserPhysicalPages": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "AllocateUserPhysicalPagesNuma": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ApplicationRecoveryFinished": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ApplicationRecoveryInProgress": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "AreFileApisANSI": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "AssignProcessToJobObject": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "AttachConsole": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BackupRead": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "BackupSeek": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BackupWrite": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "BaseCheckAppcompatCache": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "BaseCheckAppcompatCacheEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BaseCheckRunApp": SimTypeFunction((SimTypeLong(),)*13, SimTypeLong()),
    "BaseCleanupAppcompatCacheSupport": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BaseDllReadWriteIniFile": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "BaseDumpAppcompatCache": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "BaseFlushAppcompatCache": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "BaseFormatObjectAttributes": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "BaseFormatTimeOut": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BaseGenerateAppCompatData": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "BaseGetNamedObjectDirectory": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BaseInitAppcompatCacheSupport": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "BaseIsAppcompatInfrastructureDisabled": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "BaseQueryModuleData": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "BaseSetLastNTError": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BaseThreadInitThunk": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BaseUpdateAppcompatCache": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BaseVerifyUnicodeString": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "Basep8BitStringToDynamicUnicodeString": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BasepAllocateActivationContextActivationBlock": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "BasepAnsiStringToDynamicUnicodeString": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BasepCheckAppCompat": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "BasepCheckBadapp": SimTypeFunction((SimTypeLong(),)*15, SimTypeLong()),
    "BasepCheckWinSaferRestrictions": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BasepFreeActivationContextActivationBlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "BasepFreeAppCompatData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BasepMapModuleHandle": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Beep": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BeginUpdateResourceA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BeginUpdateResourceW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BindIoCompletionCallback": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BuildCommDCBA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "BuildCommDCBAndTimeoutsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BuildCommDCBAndTimeoutsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "BuildCommDCBW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CallNamedPipeA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CallNamedPipeW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CallbackMayRunLong": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CancelDeviceWakeupRequest": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CancelIo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CancelIoEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CancelSynchronousIo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CancelThreadpoolIo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CancelTimerQueueTimer": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CancelWaitableTimer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ChangeTimerQueueTimer": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CheckElevation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CheckElevationEnabled": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CheckForReadOnlyResource": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CheckNameLegalDOS8Dot3A": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CheckNameLegalDOS8Dot3W": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CheckRemoteDebuggerPresent": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ClearCommBreak": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ClearCommError": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CloseConsoleHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ClosePrivateNamespace": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CloseProfileUserMapping": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CloseThreadpool": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadpoolCleanupGroup": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadpoolCleanupGroupMembers": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CloseThreadpoolIo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadpoolTimer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadpoolWait": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CloseThreadpoolWork": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CmdBatNotification": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CommConfigDialogA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CommConfigDialogW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CompareCalendarDates": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CompareFileTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CompareStringA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CompareStringEx": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "CompareStringOrdinal": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CompareStringW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ConnectNamedPipe": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConsoleMenuControl": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ContinueDebugEvent": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ConvertCalDateTimeToSystemTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ConvertDefaultLocale": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ConvertFiberToThread": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "ConvertNLSDayOfWeekToWin32DayOfWeek": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ConvertSystemTimeToCalDateTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ConvertThreadToFiber": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ConvertThreadToFiberEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CopyContext": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CopyFileA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CopyFileExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CopyFileExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CopyFileTransactedA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CopyFileTransactedW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CopyFileW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CopyLZFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateActCtxA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CreateActCtxW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CreateBoundaryDescriptorA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateBoundaryDescriptorW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateConsoleScreenBuffer": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CreateDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateDirectoryExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateDirectoryExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateDirectoryTransactedA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateDirectoryTransactedW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateEventA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateEventExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateEventExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateEventW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateFiber": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateFiberEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "CreateFileA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateFileMappingA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreateFileMappingNumaA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateFileMappingNumaW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateFileMappingW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreateFileTransactedA": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "CreateFileTransactedW": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "CreateFileW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateHardLinkA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateHardLinkTransactedA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateHardLinkTransactedW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateHardLinkW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateIoCompletionPort": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateJobObjectA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateJobObjectW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateJobSet": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateMailslotA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateMailslotW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateMemoryResourceNotification": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CreateMutexA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateMutexExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateMutexExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateMutexW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateNamedPipeA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "CreateNamedPipeW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "CreatePipe": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreatePrivateNamespaceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreatePrivateNamespaceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateProcessA": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "CreateProcessAsUserW": SimTypeFunction((SimTypeLong(),)*11, SimTypeLong()),
    "CreateProcessInternalA": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "CreateProcessInternalW": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "CreateProcessW": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "CreateRemoteThread": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateRemoteThreadEx": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "CreateSemaphoreA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateSemaphoreExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreateSemaphoreExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreateSemaphoreW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateSocketHandle": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CreateSymbolicLinkA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateSymbolicLinkTransactedA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateSymbolicLinkTransactedW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateSymbolicLinkW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateTapePartition": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateThread": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "CreateThreadpool": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "CreateThreadpoolCleanupGroup": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CreateThreadpoolIo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateThreadpoolTimer": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateThreadpoolWait": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateThreadpoolWork": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateTimerQueue": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "CreateTimerQueueTimer": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "CreateToolhelp32Snapshot": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "CreateWaitableTimerA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CreateWaitableTimerExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateWaitableTimerExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "CreateWaitableTimerW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "CtrlRoutine": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeactivateActCtx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DebugActiveProcess": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DebugActiveProcessStop": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DebugBreak": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "DebugBreakProcess": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DebugSetProcessKillOnExit": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DecodePointer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DecodeSystemPointer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DefineDosDeviceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DefineDosDeviceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DelayLoadFailureHook": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteAtom": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteBoundaryDescriptor": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteCriticalSection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteFiber": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteFileA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteFileTransactedA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteFileTransactedW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteFileW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteProcThreadAttributeList": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteTimerQueue": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteTimerQueueEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "DeleteTimerQueueTimer": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DeleteVolumeMountPointA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeleteVolumeMountPointW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DeviceIoControl": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "DisableThreadLibraryCalls": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DisableThreadProfiling": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DisassociateCurrentThreadFromCallback": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DisconnectNamedPipe": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "DnsHostnameToComputerNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DnsHostnameToComputerNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DosDateTimeToFileTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DosPathToSessionPathA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DosPathToSessionPathW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "DuplicateConsoleHandle": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "DuplicateHandle": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "EnableThreadProfiling": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EncodePointer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EncodeSystemPointer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EndUpdateResourceA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EndUpdateResourceW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnterCriticalSection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "EnumCalendarInfoA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumCalendarInfoExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumCalendarInfoExEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnumCalendarInfoExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumCalendarInfoW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumDateFormatsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumDateFormatsExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumDateFormatsExEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumDateFormatsExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumDateFormatsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumLanguageGroupLocalesA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumLanguageGroupLocalesW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumResourceLanguagesA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EnumResourceLanguagesExA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "EnumResourceLanguagesExW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "EnumResourceLanguagesW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EnumResourceNamesA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumResourceNamesExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnumResourceNamesExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "EnumResourceNamesW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumResourceTypesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumResourceTypesExA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EnumResourceTypesExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "EnumResourceTypesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumSystemCodePagesA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnumSystemCodePagesW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnumSystemFirmwareTables": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumSystemGeoID": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumSystemLanguageGroupsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumSystemLanguageGroupsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumSystemLocalesA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnumSystemLocalesEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumSystemLocalesW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "EnumTimeFormatsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumTimeFormatsEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumTimeFormatsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumUILanguagesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumUILanguagesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EnumerateLocalComputerNamesA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EnumerateLocalComputerNamesW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "EraseTape": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "EscapeCommFunction": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ExitProcess": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ExitThread": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ExitVDM": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ExpandEnvironmentStringsA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ExpandEnvironmentStringsW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ExpungeConsoleCommandHistoryA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ExpungeConsoleCommandHistoryW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FatalAppExitA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FatalAppExitW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FatalExit": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FileTimeToDosDateTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FileTimeToLocalFileTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FileTimeToSystemTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FillConsoleOutputAttribute": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FillConsoleOutputCharacterA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FillConsoleOutputCharacterW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindActCtxSectionGuid": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindActCtxSectionStringA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindActCtxSectionStringW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindAtomA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindAtomW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindCloseChangeNotification": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindFirstChangeNotificationA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindFirstChangeNotificationW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindFirstFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindFirstFileExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "FindFirstFileExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "FindFirstFileNameTransactedW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindFirstFileNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FindFirstFileTransactedA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FindFirstFileTransactedW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FindFirstFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindFirstStreamTransactedW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FindFirstStreamW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FindFirstVolumeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindFirstVolumeMountPointA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindFirstVolumeMountPointW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindFirstVolumeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindNLSString": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FindNLSStringEx": SimTypeFunction((SimTypeLong(),)*10, SimTypeLong()),
    "FindNextChangeNotification": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindNextFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindNextFileNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindNextFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindNextStreamW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FindNextVolumeA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindNextVolumeMountPointA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindNextVolumeMountPointW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindNextVolumeW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindResourceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindResourceExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FindResourceExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "FindResourceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FindStringOrdinal": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "FindVolumeClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FindVolumeMountPointClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlsAlloc": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlsFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlsGetValue": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlsSetValue": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FlushConsoleInputBuffer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlushFileBuffers": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FlushInstructionCache": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "FlushProcessWriteBuffers": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "FlushViewOfFile": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FoldStringA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FoldStringW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "FormatMessageA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FormatMessageW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "FreeConsole": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "FreeEnvironmentStringsA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeEnvironmentStringsW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeLibrary": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeLibraryAndExitThread": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FreeLibraryWhenCallbackReturns": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "FreeResource": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "FreeUserPhysicalPages": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GenerateConsoleCtrlEvent": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetACP": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetActiveProcessorCount": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetActiveProcessorGroupCount": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetApplicationRecoveryCallback": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetApplicationRestartSettings": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetAtomNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetAtomNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetBinaryType": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetBinaryTypeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetBinaryTypeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCPInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCPInfoExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCPInfoExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCalendarDateFormat": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCalendarDateFormatEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCalendarDaysInMonth": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetCalendarDifferenceInDays": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCalendarInfoA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCalendarInfoEx": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetCalendarInfoW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCalendarMonthsInYear": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCalendarSupportedDateRange": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCalendarWeekNumber": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetComPlusPackageInstallStatus": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCommConfig": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCommMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCommModemStatus": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCommProperties": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCommState": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCommTimeouts": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCommandLineA": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCommandLineW": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCompressedFileSizeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCompressedFileSizeTransactedA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCompressedFileSizeTransactedW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCompressedFileSizeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetComputerNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetComputerNameExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetComputerNameExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetComputerNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleAliasA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetConsoleAliasExesA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleAliasExesLengthA": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetConsoleAliasExesLengthW": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetConsoleAliasExesW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleAliasW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetConsoleAliasesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleAliasesLengthA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleAliasesLengthW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleAliasesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleCP": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetConsoleCharType": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleCommandHistoryA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleCommandHistoryLengthA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleCommandHistoryLengthW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleCommandHistoryW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleCursorInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleCursorMode": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleDisplayMode": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleFontInfo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetConsoleFontSize": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleHardwareState": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetConsoleHistoryInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleInputExeNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleInputExeNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleInputWaitHandle": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetConsoleKeyboardLayoutNameA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleKeyboardLayoutNameW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleNlsMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleOriginalTitleA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleOriginalTitleW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleOutputCP": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetConsoleProcessList": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleScreenBufferInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleScreenBufferInfoEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleSelectionInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetConsoleTitleA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleTitleW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetConsoleWindow": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCurrencyFormatA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCurrencyFormatEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCurrencyFormatW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetCurrentActCtx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetCurrentConsoleFont": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCurrentConsoleFontEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetCurrentDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCurrentDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetCurrentProcess": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCurrentProcessId": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCurrentProcessorNumber": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCurrentProcessorNumberEx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetCurrentThread": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetCurrentThreadId": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetDateFormatA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetDateFormatEx": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetDateFormatW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetDefaultCommConfigA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetDefaultCommConfigW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetDevicePowerState": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetDiskFreeSpaceA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetDiskFreeSpaceExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetDiskFreeSpaceExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetDiskFreeSpaceW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetDllDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetDllDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetDriveTypeA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetDriveTypeW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetDurationFormat": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetDurationFormatEx": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetDynamicTimeZoneInformation": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetEnabledXStateFeatures": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetEnvironmentStrings": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetEnvironmentStringsA": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetEnvironmentStringsW": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetEnvironmentVariableA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetEnvironmentVariableW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetEraNameCountedString": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetErrorMode": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetExitCodeProcess": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetExitCodeThread": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetExpandedNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetExpandedNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetFileAttributesA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetFileAttributesExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetFileAttributesExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetFileAttributesTransactedA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFileAttributesTransactedW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFileAttributesW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetFileBandwidthReservation": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetFileInformationByHandle": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetFileInformationByHandleEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFileMUIInfo": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFileMUIPath": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetFileSize": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetFileSizeEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetFileTime": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFileType": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetFinalPathNameByHandleA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFinalPathNameByHandleW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFirmwareEnvironmentVariableA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFirmwareEnvironmentVariableW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFullPathNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetFullPathNameTransactedA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetFullPathNameTransactedW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetFullPathNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetGeoInfoA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetGeoInfoW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetHandleContext": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetHandleInformation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetLargePageMinimum": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetLargestConsoleWindowSize": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetLastError": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetLocalTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetLocaleInfoA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetLocaleInfoEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetLocaleInfoW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetLogicalDriveStringsA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetLogicalDriveStringsW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetLogicalDrives": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetLogicalProcessorInformation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetLogicalProcessorInformationEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetLongPathNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetLongPathNameTransactedA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetLongPathNameTransactedW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetLongPathNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetMailslotInfo": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetMaximumProcessorCount": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetMaximumProcessorGroupCount": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetModuleFileNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetModuleFileNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetModuleHandleA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetModuleHandleExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetModuleHandleExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetModuleHandleW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetNLSVersion": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetNLSVersionEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetNamedPipeAttribute": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetNamedPipeClientComputerNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetNamedPipeClientComputerNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetNamedPipeClientProcessId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNamedPipeClientSessionId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNamedPipeHandleStateA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetNamedPipeHandleStateW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "GetNamedPipeInfo": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetNamedPipeServerProcessId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNamedPipeServerSessionId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNativeSystemInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetNextVDMCommand": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetNumaAvailableMemoryNode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaAvailableMemoryNodeEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaHighestNodeNumber": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetNumaNodeNumberFromHandle": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaNodeProcessorMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaNodeProcessorMaskEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaProcessorNode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaProcessorNodeEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaProximityNode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumaProximityNodeEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumberFormatA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetNumberFormatEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetNumberFormatW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetNumberOfConsoleFonts": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetNumberOfConsoleInputEvents": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetNumberOfConsoleMouseButtons": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetOEMCP": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetOverlappedResult": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPhysicallyInstalledSystemMemory": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetPriorityClass": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetPrivateProfileIntA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPrivateProfileIntW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPrivateProfileSectionA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPrivateProfileSectionNamesA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetPrivateProfileSectionNamesW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetPrivateProfileSectionW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetPrivateProfileStringA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetPrivateProfileStringW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetPrivateProfileStructA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetPrivateProfileStructW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetProcAddress": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessAffinityMask": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProcessDEPPolicy": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProcessGroupAffinity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProcessHandleCount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessHeap": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetProcessHeaps": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessId": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetProcessIdOfThread": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetProcessIoCounters": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetProcessPriorityBoost": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessShutdownParameters": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetProcessTimes": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetProcessUserModeExceptionPolicy": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetProcessVersion": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetProcessWorkingSetSize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProcessWorkingSetSizeEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetProcessorSystemCycleTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProductInfo": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetProfileIntA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProfileIntW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProfileSectionA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProfileSectionW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetProfileStringA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetProfileStringW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetQueuedCompletionStatus": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetQueuedCompletionStatusEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetShortPathNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetShortPathNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetStartupInfoA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetStartupInfoW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetStdHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetStringScripts": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetStringTypeA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetStringTypeExA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetStringTypeExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetStringTypeW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSystemDEPPolicy": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetSystemDefaultLCID": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetSystemDefaultLangID": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetSystemDefaultLocaleName": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemDefaultUILanguage": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetSystemDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemFileCacheSize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSystemFirmwareTable": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSystemInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSystemPowerStatus": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSystemPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetSystemRegistryQuota": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSystemTimeAdjustment": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSystemTimeAsFileTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetSystemTimes": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetSystemWindowsDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemWindowsDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemWow64DirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetSystemWow64DirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetTapeParameters": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetTapePosition": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetTapeStatus": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTempFileNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetTempFileNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetTempPathA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetTempPathW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadErrorMode": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetThreadGroupAffinity": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadIOPendingFlag": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadId": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetThreadIdealProcessorEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadLocale": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetThreadPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetThreadPriority": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetThreadPriorityBoost": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetThreadSelectorEntry": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetThreadTimes": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetThreadUILanguage": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetTickCount": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetTickCount64": SimTypeFunction((SimTypeLong(),)*0, SimTypeLongLong()),
    "GetTimeFormatA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetTimeFormatEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetTimeFormatW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetTimeZoneInformation": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetTimeZoneInformationForYear": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetUILanguageInfo": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "GetUserDefaultLCID": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetUserDefaultLangID": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetUserDefaultLocaleName": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetUserDefaultUILanguage": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetUserGeoID": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetUserPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetVDMCurrentDirectories": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetVersion": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "GetVersionExA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetVersionExW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GetVolumeInformationA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetVolumeInformationByHandleW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetVolumeInformationW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "GetVolumeNameForVolumeMountPointA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetVolumeNameForVolumeMountPointW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetVolumePathNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetVolumePathNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GetVolumePathNamesForVolumeNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetVolumePathNamesForVolumeNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "GetWindowsDirectoryA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetWindowsDirectoryW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GetWriteWatch": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "GetXStateFeaturesMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GlobalAddAtomA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalAddAtomW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalAlloc": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "GlobalCompact": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalDeleteAtom": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalFindAtomA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalFindAtomW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalFix": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalFlags": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalGetAtomNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GlobalGetAtomNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GlobalHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalLock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalMemoryStatus": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalMemoryStatusEx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalReAlloc": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "GlobalSize": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalUnWire": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalUnfix": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalUnlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "GlobalWire": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "Heap32First": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "Heap32ListFirst": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Heap32ListNext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Heap32Next": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "HeapAlloc": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapCompact": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "HeapCreate": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapDestroy": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "HeapFree": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapLock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "HeapQueryInformation": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "HeapReAlloc": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "HeapSetInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "HeapSize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapSummary": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapUnlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "HeapValidate": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "HeapWalk": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IdnToAscii": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "IdnToNameprepUnicode": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "IdnToUnicode": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InitAtomTable": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitOnceBeginInitialize": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "InitOnceComplete": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "InitOnceExecuteOnce": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "InitOnceInitialize": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitializeConditionVariable": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitializeContext": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "InitializeCriticalSection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitializeCriticalSectionAndSpinCount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InitializeCriticalSectionEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "InitializeProcThreadAttributeList": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "InitializeSListHead": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InitializeSRWLock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InterlockedCompareExchange": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "InterlockedCompareExchange64": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "InterlockedDecrement": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InterlockedExchange": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InterlockedExchangeAdd": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InterlockedFlushSList": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InterlockedIncrement": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InterlockedPopEntrySList": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "InterlockedPushEntrySList": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InterlockedPushListSList": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "InvalidateConsoleDIBits": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadCodePtr": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsBadHugeReadPtr": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadHugeWritePtr": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadReadPtr": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadStringPtrA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadStringPtrW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsBadWritePtr": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsCalendarLeapDay": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "IsCalendarLeapMonth": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "IsCalendarLeapYear": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IsDBCSLeadByte": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsDBCSLeadByteEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsDebuggerPresent": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "IsNLSDefinedString": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "IsNormalizedString": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IsProcessInJob": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "IsProcessorFeaturePresent": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsSystemResumeAutomatic": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "IsThreadAFiber": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "IsThreadpoolTimerSet": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsTimeZoneRedirectionEnabled": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "IsValidCalDateTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsValidCodePage": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsValidLanguageGroup": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsValidLocale": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "IsValidLocaleName": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "IsWow64Process": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "K32EmptyWorkingSet": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "K32EnumDeviceDrivers": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32EnumPageFilesA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "K32EnumPageFilesW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "K32EnumProcessModules": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32EnumProcessModulesEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "K32EnumProcesses": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetDeviceDriverBaseNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetDeviceDriverBaseNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetDeviceDriverFileNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetDeviceDriverFileNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetMappedFileNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetMappedFileNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetModuleBaseNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetModuleBaseNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetModuleFileNameExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetModuleFileNameExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetModuleInformation": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "K32GetPerformanceInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "K32GetProcessImageFileNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetProcessImageFileNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetProcessMemoryInfo": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetWsChanges": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32GetWsChangesEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32InitializeProcessForWsWatch": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "K32QueryWorkingSet": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "K32QueryWorkingSetEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LCIDToLocaleName": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LCMapStringA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LCMapStringEx": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "LCMapStringW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LZClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LZCloseFile": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LZCopy": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LZCreateFileW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LZDone": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "LZInit": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LZOpenFileA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LZOpenFileW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LZRead": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LZSeek": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LZStart": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "LeaveCriticalSection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LeaveCriticalSectionWhenCallbackReturns": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LoadAppInitDlls": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "LoadLibraryA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LoadLibraryExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LoadLibraryExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LoadLibraryW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LoadModule": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LoadResource": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LoadStringBaseExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LoadStringBaseW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "LocalAlloc": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LocalCompact": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalFileTimeToFileTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LocalFlags": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalLock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalReAlloc": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LocalShrink": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LocalSize": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocalUnlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "LocaleNameToLCID": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "LocateXStateFeature": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "LockFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "LockFileEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "LockResource": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "MapUserPhysicalPages": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MapUserPhysicalPagesScatter": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MapViewOfFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "MapViewOfFileEx": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "MapViewOfFileExNuma": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "Module32First": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Module32FirstW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Module32Next": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Module32NextW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "MoveFileA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "MoveFileExA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MoveFileExW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MoveFileTransactedA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "MoveFileTransactedW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "MoveFileW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "MoveFileWithProgressA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "MoveFileWithProgressW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "MulDiv": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "MultiByteToWideChar": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "NeedCurrentDirectoryForExePathA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "NeedCurrentDirectoryForExePathW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "NlsCheckPolicy": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "NlsEventDataDescCreate": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "NlsGetCacheUpdateCount": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "NlsUpdateLocale": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "NlsUpdateSystemLocale": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "NlsWriteEtwEvent": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "NormalizeString": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "NotifyMountMgr": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "NotifyUILanguageChange": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "OpenConsoleW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "OpenEventA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenEventW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenFile": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenFileById": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "OpenFileMappingA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenFileMappingW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenJobObjectA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenJobObjectW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenMutexA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenMutexW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenPrivateNamespaceA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenPrivateNamespaceW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "OpenProcess": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenProcessToken": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenProfileUserMapping": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "OpenSemaphoreA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenSemaphoreW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenThread": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenThreadToken": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "OpenWaitableTimerA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OpenWaitableTimerW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "OutputDebugStringA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "OutputDebugStringW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PeekConsoleInputA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PeekConsoleInputW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PeekNamedPipe": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "PostQueuedCompletionStatus": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "PowerClearRequest": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "PowerCreateRequest": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PowerSetRequest": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "PrepareTape": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "PrivCopyFileExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "PrivMoveFileIdentityW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "Process32First": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Process32FirstW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Process32Next": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Process32NextW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ProcessIdToSessionId": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "PulseEvent": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "PurgeComm": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryActCtxSettingsW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "QueryActCtxW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "QueryDepthSList": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "QueryDosDeviceA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueryDosDeviceW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueryFullProcessImageNameA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryFullProcessImageNameW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "QueryIdleProcessorCycleTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryIdleProcessorCycleTimeEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueryInformationJobObject": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "QueryMemoryResourceNotification": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryPerformanceCounter": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "QueryPerformanceFrequency": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "QueryProcessAffinityUpdateMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryProcessCycleTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryThreadCycleTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryThreadProfiling": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryThreadpoolStackInformation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "QueryUnbiasedInterruptTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "QueueUserAPC": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "QueueUserWorkItem": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RaiseException": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RaiseFailFastException": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ReOpenFile": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ReadConsoleA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleInputA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ReadConsoleInputExA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleInputExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleInputW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ReadConsoleOutputA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleOutputAttribute": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleOutputCharacterA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleOutputCharacterW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleOutputW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadConsoleW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadDirectoryChangesW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "ReadFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadFileEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadFileScatter": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadProcessMemory": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ReadThreadProfilingData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegCloseKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegCreateKeyExA": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RegCreateKeyExW": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RegDeleteKeyExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegDeleteKeyExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegDeleteTreeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteTreeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteValueA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDeleteValueW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegDisablePredefinedCacheEx": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "RegEnumKeyExA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumKeyExW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumValueA": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegEnumValueW": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "RegFlushKey": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegGetKeySecurity": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegGetValueA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegGetValueW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegKrnGetGlobalState": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "RegKrnInitialize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegLoadKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegLoadKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegLoadMUIStringA": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegLoadMUIStringW": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "RegNotifyChangeKeyValue": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenCurrentUser": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegOpenKeyExA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenKeyExW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegOpenUserClassesRoot": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegQueryInfoKeyA": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "RegQueryInfoKeyW": SimTypeFunction((SimTypeLong(),)*12, SimTypeLong()),
    "RegQueryValueExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegQueryValueExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegRestoreKeyA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegRestoreKeyW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSaveKeyExA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegSaveKeyExW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegSetKeySecurity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RegSetValueExA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegSetValueExW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegUnLoadKeyA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegUnLoadKeyW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterApplicationRecoveryCallback": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RegisterApplicationRestart": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterConsoleIME": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RegisterConsoleOS2": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegisterConsoleVDM": SimTypeFunction((SimTypeLong(),)*9, SimTypeLong()),
    "RegisterWaitForInputIdle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegisterWaitForSingleObject": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "RegisterWaitForSingleObjectEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "RegisterWowBaseHandlers": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RegisterWowExec": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReleaseActCtx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReleaseMutex": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReleaseMutexWhenCallbackReturns": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ReleaseSRWLockExclusive": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReleaseSRWLockShared": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReleaseSemaphore": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ReleaseSemaphoreWhenCallbackReturns": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RemoveDirectoryA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RemoveDirectoryTransactedA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RemoveDirectoryTransactedW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RemoveDirectoryW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RemoveLocalAlternateComputerNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RemoveLocalAlternateComputerNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "RemoveSecureMemoryCacheCallback": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RemoveVectoredContinueHandler": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RemoveVectoredExceptionHandler": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ReplaceFile": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ReplaceFileA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ReplaceFileW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "ReplacePartitionUnit": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RequestDeviceWakeup": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RequestWakeupLatency": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ResetEvent": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ResetWriteWatch": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ResolveLocaleName": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RestoreLastError": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "ResumeThread": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RtlCaptureContext": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "RtlCaptureStackBackTrace": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RtlFillMemory": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RtlMoveMemory": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "RtlUnwind": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "RtlZeroMemory": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "ScrollConsoleScreenBufferA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "ScrollConsoleScreenBufferW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SearchPathA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SearchPathW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetCalendarInfoA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetCalendarInfoW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetClientTimeZoneInformation": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetComPlusPackageInstallStatus": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetCommBreak": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetCommConfig": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetCommMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetCommState": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetCommTimeouts": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetComputerNameA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetComputerNameExA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetComputerNameExW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetComputerNameW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleActiveScreenBuffer": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleCP": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleCtrlHandler": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleCursor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleCursorInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleCursorMode": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetConsoleCursorPosition": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleDisplayMode": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetConsoleFont": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleHardwareState": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetConsoleHistoryInfo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleIcon": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleInputExeNameA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleInputExeNameW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleKeyShortcuts": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetConsoleLocalEUDC": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetConsoleMaximumWindowSize": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleMenuClose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleNlsMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleNumberOfCommandsA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleNumberOfCommandsW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleOS2OemFormat": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleOutputCP": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsolePalette": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetConsoleScreenBufferInfoEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleScreenBufferSize": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleTextAttribute": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetConsoleTitleA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleTitleW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetConsoleWindowInfo": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetCriticalSectionSpinCount": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetCurrentConsoleFontEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetCurrentDirectoryA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetCurrentDirectoryW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetDefaultCommConfigA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetDefaultCommConfigW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetDllDirectoryA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetDllDirectoryW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetDynamicTimeZoneInformation": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEndOfFile": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEnvironmentStringsA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEnvironmentStringsW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEnvironmentVariableA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetEnvironmentVariableW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetErrorMode": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEvent": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetEventWhenCallbackReturns": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileApisToANSI": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "SetFileApisToOEM": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "SetFileAttributesA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileAttributesTransactedA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetFileAttributesTransactedW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetFileAttributesW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileBandwidthReservation": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetFileCompletionNotificationModes": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileInformationByHandle": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetFileIoOverlappedRange": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetFilePointer": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetFilePointerEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SetFileShortNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileShortNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetFileTime": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetFileValidData": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetFirmwareEnvironmentVariableA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetFirmwareEnvironmentVariableW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetHandleContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetHandleCount": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetHandleInformation": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetInformationJobObject": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetLastConsoleEventActive": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "SetLastError": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetLocalPrimaryComputerNameA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetLocalPrimaryComputerNameW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetLocalTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetLocaleInfoA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetLocaleInfoW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetMailslotInfo": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetMessageWaitingIndicator": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetNamedPipeAttribute": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "SetNamedPipeHandleState": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetPriorityClass": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetProcessAffinityMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetProcessAffinityUpdateMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetProcessDEPPolicy": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetProcessPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetProcessPriorityBoost": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetProcessShutdownParameters": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetProcessUserModeExceptionPolicy": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetProcessWorkingSetSize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetProcessWorkingSetSizeEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetSearchPathMode": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetStdHandle": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetStdHandleEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetSystemFileCacheSize": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetSystemPowerState": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetSystemTime": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetSystemTimeAdjustment": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetTapeParameters": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetTapePosition": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetTermsrvAppInstallMode": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetThreadAffinityMask": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadErrorMode": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadExecutionState": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetThreadGroupAffinity": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetThreadIdealProcessor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadIdealProcessorEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetThreadLocale": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetThreadPreferredUILanguages": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetThreadPriority": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadPriorityBoost": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadStackGuarantee": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetThreadToken": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadUILanguage": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetThreadpoolStackInformation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadpoolThreadMaximum": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadpoolThreadMinimum": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetThreadpoolTimer": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SetThreadpoolWait": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetTimeZoneInformation": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetTimerQueueTimer": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetUnhandledExceptionFilter": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetUserGeoID": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SetVDMCurrentDirectories": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetVolumeLabelA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetVolumeLabelW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetVolumeMountPointA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetVolumeMountPointW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SetWaitableTimer": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "SetXStateFeaturesMask": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SetupComm": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "ShowConsoleCursor": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SignalObjectAndWait": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SizeofResource": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Sleep": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SleepConditionVariableCS": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "SleepConditionVariableSRW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "SleepEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SortCloseHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SortGetHandle": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "StartThreadpoolIo": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SubmitThreadpoolWork": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SuspendThread": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SwitchToFiber": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "SwitchToThread": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "SystemTimeToFileTime": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "SystemTimeToTzSpecificLocalTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "TerminateJobObject": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "TerminateProcess": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "TerminateThread": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "TermsrvAppInstallMode": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "Thread32First": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Thread32Next": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "TlsAlloc": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "TlsFree": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "TlsGetValue": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "TlsSetValue": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Toolhelp32ReadProcessMemory": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "TransactNamedPipe": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "TransmitCommChar": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "TryAcquireSRWLockExclusive": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "TryAcquireSRWLockShared": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "TryEnterCriticalSection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "TrySubmitThreadpoolCallback": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "TzSpecificLocalTimeToSystemTime": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "UTRegister": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "UTUnRegister": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UnhandledExceptionFilter": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UnlockFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "UnlockFileEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "UnmapViewOfFile": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UnregisterApplicationRecoveryCallback": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "UnregisterApplicationRestart": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "UnregisterConsoleIME": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "UnregisterWait": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UnregisterWaitEx": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "UpdateCalendarDayOfWeek": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "UpdateProcThreadAttribute": SimTypeFunction((SimTypeLong(),)*7, SimTypeLong()),
    "UpdateResourceA": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "UpdateResourceW": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "VDMConsoleOperation": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "VDMOperationStarted": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "VerLanguageNameA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "VerLanguageNameW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "VerSetConditionMask": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VerifyConsoleIoHandle": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "VerifyScripts": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "VerifyVersionInfoA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VerifyVersionInfoW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VirtualAlloc": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VirtualAllocEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "VirtualAllocExNuma": SimTypeFunction((SimTypeLong(),)*6, SimTypeLong()),
    "VirtualFree": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "VirtualFreeEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VirtualLock": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "VirtualProtect": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VirtualProtectEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "VirtualQuery": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "VirtualQueryEx": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "VirtualUnlock": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WTSGetActiveConsoleSessionId": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "WaitCommEvent": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WaitForDebugEvent": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitForMultipleObjects": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WaitForMultipleObjectsEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WaitForSingleObject": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitForSingleObjectEx": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WaitForThreadpoolIoCallbacks": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitForThreadpoolTimerCallbacks": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitForThreadpoolWaitCallbacks": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitForThreadpoolWorkCallbacks": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitNamedPipeA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WaitNamedPipeW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WakeAllConditionVariable": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WakeConditionVariable": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerGetFlags": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WerRegisterFile": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WerRegisterMemoryBlock": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WerRegisterRuntimeExceptionModule": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WerSetFlags": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerUnregisterFile": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerUnregisterMemoryBlock": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerUnregisterRuntimeExceptionModule": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WerpCleanupMessageMapping": SimTypeFunction((SimTypeLong(),)*0, SimTypeLong()),
    "WerpInitiateRemoteRecovery": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerpNotifyLoadStringResource": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WerpNotifyLoadStringResourceEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WerpNotifyUseStringResource": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WerpStringLookup": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WideCharToMultiByte": SimTypeFunction((SimTypeLong(),)*8, SimTypeLong()),
    "WinExec": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Wow64DisableWow64FsRedirection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "Wow64EnableWow64FsRedirection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "Wow64GetThreadContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Wow64GetThreadSelectorEntry": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "Wow64RevertWow64FsRedirection": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "Wow64SetThreadContext": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "Wow64SuspendThread": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "WriteConsoleA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleInputA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WriteConsoleInputVDMA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WriteConsoleInputVDMW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WriteConsoleInputW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WriteConsoleOutputA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleOutputAttribute": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleOutputCharacterA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleOutputCharacterW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleOutputW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteConsoleW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteFile": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteFileEx": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteFileGather": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WritePrivateProfileSectionA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WritePrivateProfileSectionW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WritePrivateProfileStringA": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WritePrivateProfileStringW": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "WritePrivateProfileStructA": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WritePrivateProfileStructW": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteProcessMemory": SimTypeFunction((SimTypeLong(),)*5, SimTypeLong()),
    "WriteProfileSectionA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WriteProfileSectionW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "WriteProfileStringA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WriteProfileStringW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "WriteTapemark": SimTypeFunction((SimTypeLong(),)*4, SimTypeLong()),
    "ZombifyActCtx": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "_hread": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "_hwrite": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "_lclose": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "_lcreat": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "_llseek": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "_lopen": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "_lread": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "_lwrite": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "lstrcat": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcatA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcatW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmp": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmpA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmpW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmpi": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmpiA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcmpiW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcpy": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcpyA": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcpyW": SimTypeFunction((SimTypeLong(),)*2, SimTypeLong()),
    "lstrcpyn": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "lstrcpynA": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "lstrcpynW": SimTypeFunction((SimTypeLong(),)*3, SimTypeLong()),
    "lstrlen": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "lstrlenA": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong()),
    "lstrlenW": SimTypeFunction((SimTypeLong(),)*1, SimTypeLong())
}

lib.set_prototypes(prototypes)
