function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { upperFirst } from 'lodash';
import { ChartModes, ChartTypes, InterpolationModes, Positions } from '../../../utils/collections';

var makeSerie = function makeSerie(id, label, defaultValueAxis, lastSerie) {
  var data = {
    id: id,
    label: label
  };
  var defaultSerie = {
    show: true,
    mode: ChartModes.NORMAL,
    type: ChartTypes.LINE,
    drawLinesBetweenPoints: true,
    showCircles: true,
    interpolate: InterpolationModes.LINEAR,
    lineWidth: 2,
    valueAxis: defaultValueAxis,
    data: data
  };
  return lastSerie ? _objectSpread(_objectSpread({}, lastSerie), {}, {
    data: data
  }) : defaultSerie;
};

var isAxisHorizontal = function isAxisHorizontal(position) {
  return [Positions.TOP, Positions.BOTTOM].includes(position);
};

var RADIX = 10;

function countNextAxisNumber(axisName) {
  var axisProp = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'id';
  return function (value, axis) {
    var nameLength = axisName.length;

    if (axis[axisProp].substr(0, nameLength) === axisName) {
      var num = parseInt(axis[axisProp].substr(nameLength), RADIX);

      if (num >= value) {
        value = num + 1;
      }
    }

    return value;
  };
}

var AXIS_PREFIX = 'Axis-';

var getUpdatedAxisName = function getUpdatedAxisName(axisPosition, valueAxes) {
  var axisName = upperFirst(axisPosition) + AXIS_PREFIX;
  var nextAxisNameNumber = valueAxes.reduce(countNextAxisNumber(axisName, 'name'), 1);
  return "".concat(axisName).concat(nextAxisNameNumber);
};

function mapPositionOpposite(position) {
  switch (position) {
    case Positions.BOTTOM:
      return Positions.TOP;

    case Positions.TOP:
      return Positions.BOTTOM;

    case Positions.LEFT:
      return Positions.RIGHT;

    case Positions.RIGHT:
      return Positions.LEFT;

    default:
      throw new Error('Invalid legend position.');
  }
}

function mapPosition(position) {
  switch (position) {
    case Positions.BOTTOM:
      return Positions.LEFT;

    case Positions.TOP:
      return Positions.RIGHT;

    case Positions.LEFT:
      return Positions.BOTTOM;

    case Positions.RIGHT:
      return Positions.TOP;
  }
}

export { makeSerie, isAxisHorizontal, countNextAxisNumber, getUpdatedAxisName, mapPositionOpposite, mapPosition };