/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiFlexGroup, EuiFlexItem, EuiSpacer } from '@elastic/eui';
import { NumberInputOption, SelectOption, SwitchOption } from '../../../../../charts/public';

function LineOptions(_ref) {
  var chart = _ref.chart,
      vis = _ref.vis,
      setChart = _ref.setChart;
  var setLineWidth = useCallback(function (paramName, value) {
    setChart(paramName, value === '' ? undefined : value);
  }, [setChart]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.showLineLabel', {
      defaultMessage: 'Show line'
    }),
    paramName: "drawLinesBetweenPoints",
    value: chart.drawLinesBetweenPoints,
    setValue: setChart
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(SelectOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: vis.type.editorConfig.collections.interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(NumberInputOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.lineWidthLabel', {
      defaultMessage: 'Line width'
    }),
    paramName: "lineWidth",
    step: 0.5,
    min: 0,
    value: chart.lineWidth,
    setValue: setLineWidth
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.series.showDotsLabel', {
      defaultMessage: 'Show dots'
    }),
    paramName: "showCircles",
    value: chart.showCircles,
    setValue: setChart
  }));
}

export { LineOptions };