function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import angular from 'angular';
import $ from 'jquery';
import { getAngularModule } from './get_inner_angular';
import { getKibanaLegacy } from './services';
import { initTableVisLegacyModule } from './table_vis_legacy_module';
var innerAngularName = 'kibana/table_vis';
export function getTableVisualizationControllerClass(core, context) {
  var _temp;

  return _temp = /*#__PURE__*/function () {
    function TableVisualizationController(domeElement, vis) {
      _classCallCheck(this, TableVisualizationController);

      _defineProperty(this, "tableVisModule", void 0);

      _defineProperty(this, "injector", void 0);

      _defineProperty(this, "el", void 0);

      _defineProperty(this, "vis", void 0);

      _defineProperty(this, "$rootScope", null);

      _defineProperty(this, "$scope", void 0);

      _defineProperty(this, "$compile", void 0);

      this.el = $(domeElement);
      this.vis = vis;
    }

    _createClass(TableVisualizationController, [{
      key: "getInjector",
      value: function getInjector() {
        if (!this.injector) {
          var mountpoint = document.createElement('div');
          mountpoint.setAttribute('style', 'height: 100%; width: 100%;');
          this.injector = angular.bootstrap(mountpoint, [innerAngularName]);
          this.el.append(mountpoint);
        }

        return this.injector;
      }
    }, {
      key: "initLocalAngular",
      value: function () {
        var _initLocalAngular = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
          var _yield$core$getStartS, _yield$core$getStartS2, coreStart;

          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  if (this.tableVisModule) {
                    _context.next = 8;
                    break;
                  }

                  _context.next = 3;
                  return core.getStartServices();

                case 3:
                  _yield$core$getStartS = _context.sent;
                  _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 1);
                  coreStart = _yield$core$getStartS2[0];
                  this.tableVisModule = getAngularModule(innerAngularName, coreStart, context);
                  initTableVisLegacyModule(this.tableVisModule);

                case 8:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, this);
        }));

        function initLocalAngular() {
          return _initLocalAngular.apply(this, arguments);
        }

        return initLocalAngular;
      }()
    }, {
      key: "render",
      value: function () {
        var _render = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(esResponse, visParams) {
          var _this = this;

          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  getKibanaLegacy().loadFontAwesome();
                  _context3.next = 3;
                  return this.initLocalAngular();

                case 3:
                  return _context3.abrupt("return", new Promise( /*#__PURE__*/function () {
                    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(resolve, reject) {
                      var $injector, updateScope;
                      return regeneratorRuntime.wrap(function _callee2$(_context2) {
                        while (1) {
                          switch (_context2.prev = _context2.next) {
                            case 0:
                              if (!_this.$rootScope) {
                                $injector = _this.getInjector();
                                _this.$rootScope = $injector.get('$rootScope');
                                _this.$compile = $injector.get('$compile');
                              }

                              updateScope = function updateScope() {
                                if (!_this.$scope) {
                                  return;
                                } // How things get into this $scope?
                                // To inject variables into this $scope there's the following pipeline of stuff to check:
                                // - visualize_embeddable => that's what the editor creates to wrap this Angular component
                                // - build_pipeline => it serialize all the params into an Angular template compiled on the fly
                                // - table_vis_fn => unserialize the params and prepare them for the final React/Angular bridge
                                // - visualization_renderer => creates the wrapper component for this controller and passes the params
                                //
                                // In case some prop is missing check into the top of the chain if they are available and check
                                // the list above that it is passing through


                                _this.$scope.vis = _this.vis;
                                _this.$scope.visState = {
                                  params: visParams,
                                  title: visParams.title
                                };
                                _this.$scope.esResponse = esResponse;
                                _this.$scope.visParams = visParams;
                                _this.$scope.renderComplete = resolve;
                                _this.$scope.renderFailed = reject;
                                _this.$scope.resize = Date.now();

                                _this.$scope.$apply();
                              };

                              if (!_this.$scope && _this.$compile) {
                                _this.$scope = _this.$rootScope.$new();
                                _this.$scope.uiState = _this.vis.getUiState();
                                updateScope();

                                _this.el.find('div').append(_this.$compile(_this.vis.type.visConfig.template)(_this.$scope));

                                _this.$scope.$apply();
                              } else {
                                updateScope();
                              }

                            case 3:
                            case "end":
                              return _context2.stop();
                          }
                        }
                      }, _callee2);
                    }));

                    return function (_x3, _x4) {
                      return _ref.apply(this, arguments);
                    };
                  }()));

                case 4:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3, this);
        }));

        function render(_x, _x2) {
          return _render.apply(this, arguments);
        }

        return render;
      }()
    }, {
      key: "destroy",
      value: function destroy() {
        if (this.$rootScope) {
          this.$rootScope.$destroy();
          this.$rootScope = null;
        }
      }
    }]);

    return TableVisualizationController;
  }(), _temp;
}