function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiContextMenu, EuiPopover } from '@elastic/eui';
import { EventEmitter } from 'events';
import ReactDOM from 'react-dom';
var activeSession = null;
var CONTAINER_ID = 'contextMenu-container';
/**
 * Tries to find best position for opening context menu using mousemove and click event
 * Returned position is relative to document
 */

export function createInteractionPositionTracker() {
  var lastMouseX = 0;
  var lastMouseY = 0;
  var lastClicks = [];
  var MAX_LAST_CLICKS = 10;
  /**
   * Track both `mouseup` and `click`
   * `mouseup` is for clicks and brushes with mouse
   * `click` is a fallback for keyboard interactions
   */

  document.addEventListener('mouseup', onClick, true);
  document.addEventListener('click', onClick, true);
  document.addEventListener('mousemove', onMouseUpdate, {
    passive: true
  });
  document.addEventListener('mouseenter', onMouseUpdate, {
    passive: true
  });

  function onClick(event) {
    lastClicks.push({
      el: event.target,
      mouseX: event.clientX,
      mouseY: event.clientY
    });

    if (lastClicks.length > MAX_LAST_CLICKS) {
      lastClicks.shift();
    }
  }

  function onMouseUpdate(event) {
    lastMouseX = event.clientX;
    lastMouseY = event.clientY;
  }

  return {
    resolveLastPosition: function resolveLastPosition() {
      var lastClick = [].concat(lastClicks).reverse().find(function (_ref) {
        var el = _ref.el;
        return el && document.body.contains(el);
      });

      if (!lastClick) {
        // fallback to last mouse position
        return {
          x: lastMouseX,
          y: lastMouseY
        };
      }

      var _getBoundingClientRec = lastClick.el.getBoundingClientRect(),
          top = _getBoundingClientRec.top,
          left = _getBoundingClientRec.left,
          bottom = _getBoundingClientRec.bottom,
          right = _getBoundingClientRec.right;

      var mouseX = lastClick.mouseX;
      var mouseY = lastClick.mouseY;

      if (top <= mouseY && bottom >= mouseY && left <= mouseX && right >= mouseX) {
        // click was inside target element
        return {
          x: mouseX,
          y: mouseY
        };
      } else {
        // keyboard edge case. no cursor position. use target element position instead
        return {
          x: left + (right - left) / 2,
          y: bottom
        };
      }
    }
  };
}

var _createInteractionPos = createInteractionPositionTracker(),
    resolveLastPosition = _createInteractionPos.resolveLastPosition;

function getOrCreateContainerElement() {
  var container = document.getElementById(CONTAINER_ID);

  var _resolveLastPosition = resolveLastPosition(),
      x = _resolveLastPosition.x,
      y = _resolveLastPosition.y;

  y = y + window.scrollY;
  x = x + window.scrollX;

  if (!container) {
    container = document.createElement('div');
    container.style.left = x + 'px';
    container.style.top = y + 'px';
    container.style.position = 'absolute'; // EUI tooltip uses 9000
    // have to make it larger to display menu on top of tooltips from charts

    container.style.zIndex = '9999';
    container.id = CONTAINER_ID;
    document.body.appendChild(container);
  } else {
    container.style.left = x + 'px';
    container.style.top = y + 'px';
  }

  return container;
}
/**
 * A FlyoutSession describes the session of one opened flyout panel. It offers
 * methods to close the flyout panel again. If you open a flyout panel you should make
 * sure you call {@link ContextMenuSession#close} when it should be closed.
 * Since a flyout could also be closed without calling this method (e.g. because
 * the user closes it), you must listen to the "closed" event on this instance.
 * It will be emitted whenever the flyout will be closed and you should throw
 * away your reference to this instance whenever you receive that event.
 * @extends EventEmitter
 */


var ContextMenuSession = /*#__PURE__*/function (_EventEmitter) {
  _inherits(ContextMenuSession, _EventEmitter);

  var _super = _createSuper(ContextMenuSession);

  function ContextMenuSession() {
    _classCallCheck(this, ContextMenuSession);

    return _super.apply(this, arguments);
  }

  _createClass(ContextMenuSession, [{
    key: "close",

    /**
     * Closes the opened flyout as long as it's still the open one.
     * If this is not the active session anymore, this method won't do anything.
     * If this session was still active and a flyout was closed, the 'closed'
     * event will be emitted on this FlyoutSession instance.
     */
    value: function close() {
      if (activeSession === this) {
        var container = document.getElementById(CONTAINER_ID);

        if (container) {
          ReactDOM.unmountComponentAtNode(container);
          this.emit('closed');
        }
      }
    }
  }]);

  return ContextMenuSession;
}(EventEmitter);
/**
 * Opens a flyout panel with the given component inside. You can use
 * {@link ContextMenuSession#close} on the return value to close the flyout.
 *
 * @param flyoutChildren - Mounts the children inside a fly out panel
 * @return {FlyoutSession} The session instance for the opened flyout panel.
 */


export function openContextMenu(panels) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  // If there is an active inspector session close it before opening a new one.
  if (activeSession) {
    activeSession.close();
  }

  var container = getOrCreateContainerElement();
  var session = activeSession = new ContextMenuSession();

  var onClose = function onClose() {
    if (props.onClose) {
      props.onClose();
    }

    session.close();
  };

  ReactDOM.render( /*#__PURE__*/React.createElement(EuiPopover, {
    className: "embPanel__optionsMenuPopover",
    button: container,
    isOpen: true,
    closePopover: onClose,
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    withTitle: true,
    ownFocus: true
  }, /*#__PURE__*/React.createElement(EuiContextMenu, {
    initialPanelId: "mainMenu",
    panels: panels,
    "data-test-subj": props['data-test-subj']
  })), container);
  return session;
}
export { ContextMenuSession };