function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiButton, EuiButtonEmpty, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { CONTROL_TYPES } from '../../editor_utils';
import { ListControl as ListControlComponent } from './list_control';
import { RangeControl as RangeControlComponent } from './range_control';

function isListControl(control) {
  return control.type === CONTROL_TYPES.LIST;
}

function isRangeControl(control) {
  return control.type === CONTROL_TYPES.RANGE;
}

export var InputControlVis = /*#__PURE__*/function (_Component) {
  _inherits(InputControlVis, _Component);

  var _super = _createSuper(InputControlVis);

  function InputControlVis(props) {
    var _this;

    _classCallCheck(this, InputControlVis);

    _this = _super.call(this, props);
    _this.handleSubmit = _this.handleSubmit.bind(_assertThisInitialized(_this));
    _this.handleReset = _this.handleReset.bind(_assertThisInitialized(_this));
    _this.handleClearAll = _this.handleClearAll.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(InputControlVis, [{
    key: "handleSubmit",
    value: function handleSubmit() {
      this.props.submitFilters();
    }
  }, {
    key: "handleReset",
    value: function handleReset() {
      this.props.resetControls();
    }
  }, {
    key: "handleClearAll",
    value: function handleClearAll() {
      this.props.clearControls();
    }
  }, {
    key: "renderControls",
    value: function renderControls() {
      var _this2 = this;

      return this.props.controls.map(function (control, index) {
        var controlComponent = null;

        if (isListControl(control)) {
          controlComponent = /*#__PURE__*/React.createElement(ListControlComponent, {
            id: control.id,
            label: control.label,
            options: control.selectOptions,
            selectedOptions: control.value,
            formatOptionLabel: control.format,
            disableMsg: control.isEnabled() ? undefined : control.disabledReason,
            multiselect: control.options.multiselect,
            partialResults: control.partialResults,
            dynamicOptions: control.options.dynamicOptions,
            controlIndex: index,
            stageFilter: _this2.props.stageFilter,
            fetchOptions: function fetchOptions(query) {
              _this2.props.refreshControl(index, query);
            }
          });
        } else if (isRangeControl(control)) {
          controlComponent = /*#__PURE__*/React.createElement(RangeControlComponent, {
            control: control,
            controlIndex: index,
            stageFilter: _this2.props.stageFilter
          });
        } else {
          throw new Error("Unhandled control type ".concat(control.type));
        }

        return /*#__PURE__*/React.createElement(EuiFlexItem, {
          key: control.id,
          style: {
            minWidth: '250px'
          },
          "data-test-subj": "inputControlItem"
        }, controlComponent);
      });
    }
  }, {
    key: "renderStagingButtons",
    value: function renderStagingButtons() {
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        wrap: true
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        onClick: this.handleSubmit,
        disabled: !this.props.hasChanges(),
        "data-test-subj": "inputControlSubmitBtn"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.vis.inputControlVis.applyChangesButtonLabel",
        defaultMessage: "Apply changes"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: this.handleReset,
        disabled: !this.props.hasChanges(),
        "data-test-subj": "inputControlCancelBtn"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.vis.inputControlVis.cancelChangesButtonLabel",
        defaultMessage: "Cancel changes"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: this.handleClearAll,
        disabled: !this.props.hasValues(),
        "data-test-subj": "inputControlClearBtn"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.vis.inputControlVis.clearFormButtonLabel",
        defaultMessage: "Clear form"
      }))));
    }
  }, {
    key: "render",
    value: function render() {
      var stagingButtons;

      if (this.props.controls.length > 0 && !this.props.updateFiltersOnChange) {
        stagingButtons = this.renderStagingButtons();
      }

      return /*#__PURE__*/React.createElement("div", {
        className: "icvContainer"
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        wrap: true
      }, this.renderControls()), stagingButtons);
    }
  }]);

  return InputControlVis;
}(Component);