function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { EuiButton, EuiButtonEmpty, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
var DEFAULT_TEXTS = {
  back: i18n.translate('esUi.formWizard.backButtonLabel', {
    defaultMessage: 'Back'
  }),
  next: i18n.translate('esUi.formWizard.nextButtonLabel', {
    defaultMessage: 'Next'
  }),
  save: i18n.translate('esUi.formWizard.saveButtonLabel', {
    defaultMessage: 'Save'
  }),
  saving: i18n.translate('esUi.formWizard.savingButtonLabel', {
    defaultMessage: 'Saving...'
  })
};
export var FormWizardNav = function FormWizardNav(_ref) {
  var activeStepIndex = _ref.activeStepIndex,
      lastStep = _ref.lastStep,
      isStepValid = _ref.isStepValid,
      isSaving = _ref.isSaving,
      onBack = _ref.onBack,
      onNext = _ref.onNext,
      texts = _ref.texts;
  var isLastStep = activeStepIndex === lastStep;

  var labels = _objectSpread(_objectSpread({}, DEFAULT_TEXTS), texts);

  var nextButtonLabel = isLastStep ? Boolean(isSaving) ? labels.saving : labels.save : labels.next;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, null, activeStepIndex > 0 ? /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: onBack,
    "data-test-subj": "backButton",
    disabled: isStepValid === false
  }, labels.back)) : null, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    fill: true,
    iconType: isLastStep ? 'check' : 'arrowRight',
    onClick: onNext,
    iconSide: isLastStep ? 'left' : 'right',
    disabled: isStepValid === false,
    "data-test-subj": "nextButton",
    isLoading: isSaving
  }, nextButtonLabel)))));
};