function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { UI_SETTINGS } from '../../../common';
var sessionId = Date.now();
export function getSearchParams(config) {
  var esShardTimeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  return {
    rest_total_hits_as_int: true,
    ignore_unavailable: true,
    ignore_throttled: getIgnoreThrottled(config),
    max_concurrent_shard_requests: getMaxConcurrentShardRequests(config),
    preference: getPreference(config),
    timeout: getTimeout(esShardTimeout)
  };
}
export function getIgnoreThrottled(config) {
  return !config.get(UI_SETTINGS.SEARCH_INCLUDE_FROZEN);
}
export function getMaxConcurrentShardRequests(config) {
  var maxConcurrentShardRequests = config.get(UI_SETTINGS.COURIER_MAX_CONCURRENT_SHARD_REQUESTS);
  return maxConcurrentShardRequests > 0 ? maxConcurrentShardRequests : undefined;
}
export function getPreference(config) {
  var setRequestPreference = config.get(UI_SETTINGS.COURIER_SET_REQUEST_PREFERENCE);
  if (setRequestPreference === 'sessionId') return sessionId;
  return setRequestPreference === 'custom' ? config.get(UI_SETTINGS.COURIER_CUSTOM_REQUEST_PREFERENCE) : undefined;
}
export function getTimeout(esShardTimeout) {
  return esShardTimeout > 0 ? "".concat(esShardTimeout, "ms") : undefined;
}
export function getSearchParamsFromRequest(searchRequest, dependencies) {
  var injectedMetadata = dependencies.injectedMetadata,
      uiSettings = dependencies.uiSettings;
  var esShardTimeout = injectedMetadata.getInjectedVar('esShardTimeout');
  var searchParams = getSearchParams(uiSettings, esShardTimeout);
  return _objectSpread({
    index: searchRequest.index.title || searchRequest.index,
    body: searchRequest.body
  }, searchParams);
}