function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * This is the entry point used to boot the frontend when serving a application
 * that lives in the Kibana Platform.
 *
 * Any changes to this file should be kept in sync with
 * src/legacy/ui/ui_bundles/app_entry_template.js
 */
import { i18n } from '@kbn/i18n';
import { CoreSystem } from './core_system';
/** @internal */

export function __kbnBootstrap__() {
  var injectedMetadata = JSON.parse(document.querySelector('kbn-injected-metadata').getAttribute('data'));
  /**
   * `apmConfig` would be populated with relavant APM RUM agent
   * configuration if server is started with `ELASTIC_APM_ACTIVE=true`
   */

  var apmConfig = injectedMetadata.vars.apmConfig;
  var APM_ENABLED = process.env.IS_KIBANA_DISTRIBUTABLE !== 'true' && apmConfig != null;

  if (APM_ENABLED) {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    var _require = require('@elastic/apm-rum'),
        init = _require.init,
        apm = _require.apm;

    if (apmConfig.globalLabels) {
      apm.addLabels(apmConfig.globalLabels);
    }

    init(apmConfig);
  }

  i18n.load(injectedMetadata.i18n.translationsUrl).catch(function (e) {
    return e;
  }).then( /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(i18nError) {
      var coreSystem, setup, start;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              coreSystem = new CoreSystem({
                injectedMetadata: injectedMetadata,
                rootDomElement: document.body,
                browserSupportsCsp: !window.__kbnCspNotEnforced__
              });
              _context.next = 3;
              return coreSystem.setup();

            case 3:
              setup = _context.sent;

              if (i18nError && setup) {
                setup.fatalErrors.add(i18nError);
              }

              _context.next = 7;
              return coreSystem.start();

            case 7:
              start = _context.sent;

              if (APM_ENABLED && start) {
                /**
                 * Register listeners for navigation changes and capture them as
                 * route-change transactions after Kibana app is bootstrapped
                 */
                start.application.currentAppId$.subscribe(function (appId) {
                  var apmInstance = window.elasticApm;

                  if (appId && apmInstance && typeof apmInstance.startTransaction === 'function') {
                    apmInstance.startTransaction("/app/".concat(appId), 'route-change', {
                      managed: true,
                      canReuse: true
                    });
                  }
                });
              }

            case 9:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }());
}