"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGrid = void 0;

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _tabbable = _interopRequireDefault(require("tabbable"));

var _i18n = require("../i18n");

var _data_grid_header_row = require("./data_grid_header_row");

var _button = require("../button");

var _services = require("../../services");

var _data_grid_body = require("./data_grid_body");

var _column_selector = require("./column_selector");

var _style_selector = require("./style_selector");

var _table_pagination = require("../table/table_pagination");

var _focus_trap = require("../focus_trap");

var _resize_observer = require("../observer/resize_observer");

var _data_grid_inmemory_renderer = require("./data_grid_inmemory_renderer");

var _data_grid_schema = require("./data_grid_schema");

var _column_sorting = require("./column_sorting");

var _mutation_observer = require("../observer/mutation_observer");

var _data_grid_context = require("./data_grid_context");

var _resize_observer2 = require("../observer/resize_observer/resize_observer");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Used to short-circuit some async browser behaviour that is difficult to account for in tests
var IS_JEST_ENVIRONMENT = global.hasOwnProperty('_isJest'); // When below this number the grid only shows the full screen button

var MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479;
// Each gridStyle object above sets a specific CSS select to .euiGrid
var fontSizesToClassMap = {
  s: 'euiDataGrid--fontSizeSmall',
  m: '',
  l: 'euiDataGrid--fontSizeLarge'
};
var headerToClassMap = {
  shade: 'euiDataGrid--headerShade',
  underline: 'euiDataGrid--headerUnderline'
};
var rowHoverToClassMap = {
  highlight: 'euiDataGrid--rowHoverHighlight',
  none: ''
};
var bordersToClassMap = {
  all: 'euiDataGrid--bordersAll',
  horizontal: 'euiDataGrid--bordersHorizontal',
  none: 'euiDataGrid--bordersNone'
};
var cellPaddingsToClassMap = {
  s: 'euiDataGrid--paddingSmall',
  m: '',
  l: 'euiDataGrid--paddingLarge'
};

function computeVisibleRows(props) {
  var pagination = props.pagination,
      rowCount = props.rowCount;
  var startRow = pagination ? pagination.pageIndex * pagination.pageSize : 0;
  var endRow = pagination ? (pagination.pageIndex + 1) * pagination.pageSize : rowCount;
  endRow = Math.min(endRow, rowCount);
  return endRow - startRow;
}

function renderPagination(props, controls) {
  var pagination = props.pagination;

  if (pagination == null) {
    return null;
  }

  var pageIndex = pagination.pageIndex,
      pageSize = pagination.pageSize,
      pageSizeOptions = pagination.pageSizeOptions,
      onChangePage = pagination.onChangePage,
      onChangeItemsPerPage = pagination.onChangeItemsPerPage;
  var pageCount = Math.ceil(props.rowCount / pageSize);

  if (props.rowCount < pageSizeOptions[0]) {
    return null;
  }

  return _react.default.createElement(_i18n.EuiI18n, {
    token: "euiDataGrid.ariaLabelGridPagination",
    default: "Pagination for preceding grid: {label}",
    values: {
      label: props['aria-label']
    }
  }, function (ariaLabelGridPagination) {
    return _react.default.createElement(_i18n.EuiI18n, {
      token: "euiDataGrid.ariaLabelledByGridPagination",
      default: "Pagination for preceding grid"
    }, function (ariaLabelledByGridPagination) {
      var accessibleName = _objectSpread({}, props['aria-label'] && {
        'aria-label': ariaLabelGridPagination
      }, {}, props['aria-labelledby'] && {
        'aria-labelledby': ariaLabelledByGridPagination
      });

      return _react.default.createElement("div", {
        className: "euiDataGrid__pagination"
      }, _react.default.createElement(_table_pagination.EuiTablePagination, _extends({
        "aria-controls": controls,
        activePage: pageIndex,
        itemsPerPage: pageSize,
        itemsPerPageOptions: pageSizeOptions,
        pageCount: pageCount,
        onChangePage: onChangePage,
        onChangeItemsPerPage: onChangeItemsPerPage
      }, accessibleName)));
    });
  });
}

function useDefaultColumnWidth(container, leadingControlColumns, trailingControlColumns, columns) {
  var containerSize = (0, _resize_observer2.useResizeObserver)(container, 'width');
  var gridWidth = containerSize.width;
  var computeDefaultWidth = (0, _react.useCallback)(function () {
    if (IS_JEST_ENVIRONMENT) return 100;
    if (gridWidth === 0) return null; // we can't tell what size to compute yet

    var controlColumnWidths = [].concat(_toConsumableArray(leadingControlColumns), _toConsumableArray(trailingControlColumns)).reduce(function (claimedWidth, controlColumn) {
      return claimedWidth + controlColumn.width;
    }, 0);
    var columnsWithWidths = columns.filter(doesColumnHaveAnInitialWidth);
    var definedColumnsWidth = columnsWithWidths.reduce(function (claimedWidth, column) {
      return claimedWidth + column.initialWidth;
    }, 0);
    var claimedWidth = controlColumnWidths + definedColumnsWidth;
    var widthToFill = gridWidth - claimedWidth;
    var unsizedColumnCount = columns.length - columnsWithWidths.length;
    return Math.max(widthToFill / unsizedColumnCount, 100);
  }, [gridWidth, columns, leadingControlColumns, trailingControlColumns]);

  var _useState = (0, _react.useState)(computeDefaultWidth),
      _useState2 = _slicedToArray(_useState, 2),
      defaultColumnWidth = _useState2[0],
      setDefaultColumnWidth = _useState2[1];

  (0, _react.useEffect)(function () {
    var columnWidth = computeDefaultWidth();
    setDefaultColumnWidth(columnWidth);
  }, [computeDefaultWidth]);
  return defaultColumnWidth;
}

function doesColumnHaveAnInitialWidth(column) {
  return column.hasOwnProperty('initialWidth');
}

function useColumnWidths(columns, onColumnResize) {
  var hasMounted = (0, _react.useRef)(false);
  var computeColumnWidths = (0, _react.useCallback)(function () {
    return columns.filter(doesColumnHaveAnInitialWidth).reduce(function (initialWidths, column) {
      initialWidths[column.id] = column.initialWidth;
      return initialWidths;
    }, {});
  }, [columns]);

  var _useState3 = (0, _react.useState)(computeColumnWidths),
      _useState4 = _slicedToArray(_useState3, 2),
      columnWidths = _useState4[0],
      setColumnWidths = _useState4[1];

  (0, _react.useEffect)(function () {
    if (!hasMounted.current) {
      hasMounted.current = true;
      return;
    }

    setColumnWidths(computeColumnWidths());
  }, [computeColumnWidths]);

  var setColumnWidth = function setColumnWidth(columnId, width) {
    setColumnWidths(_objectSpread({}, columnWidths, _defineProperty({}, columnId, width)));

    if (onColumnResize) {
      onColumnResize({
        columnId: columnId,
        width: width
      });
    }
  };

  return [columnWidths, setColumnWidth];
}

function useOnResize(setHasRoomForGridControls, isFullScreen, minSizeForControls) {
  return (0, _react.useCallback)(function (_ref) {
    var width = _ref.width;
    setHasRoomForGridControls(width > minSizeForControls || isFullScreen);
  }, [setHasRoomForGridControls, isFullScreen, minSizeForControls]);
}

function useInMemoryValues(inMemory, rowCount) {
  /**
   * For performance, `onCellRender` below mutates the inMemoryValues object
   * instead of cloning. If this operation were done in a setState call
   * React would ignore the update as the object itself has not changed.
   * So, we keep a dual record: the in-memory values themselves and a "version" counter.
   * When the object is mutated, the version is incremented triggering a re-render, and
   * the returned `inMemoryValues` object is re-created (cloned) from the mutated version.
   * The version updates are batched, so only one clone happens per batch.
   **/
  var _inMemoryValues = (0, _react.useRef)({});

  var _useState5 = (0, _react.useState)(0),
      _useState6 = _slicedToArray(_useState5, 2),
      inMemoryValuesVersion = _useState6[0],
      setInMemoryValuesVersion = _useState6[1]; // eslint-disable-next-line react-hooks/exhaustive-deps


  var inMemoryValues = (0, _react.useMemo)(function () {
    return _objectSpread({}, _inMemoryValues.current);
  }, [inMemoryValuesVersion]);
  var onCellRender = (0, _react.useCallback)(function (rowIndex, columnId, value) {
    var nextInMemoryValues = _inMemoryValues.current;
    nextInMemoryValues[rowIndex] = nextInMemoryValues[rowIndex] || {};
    nextInMemoryValues[rowIndex][columnId] = value;
    setInMemoryValuesVersion(function (version) {
      return version + 1;
    });
  }, []); // if `inMemory.level` or `rowCount` changes reset the values

  var inMemoryLevel = inMemory && inMemory.level;
  var resetRunCount = (0, _react.useRef)(0);
  (0, _react.useEffect)(function () {
    if (resetRunCount.current++ > 0) {
      // this has to delete "overflow" keys from the object instead of resetting to an empty one,
      // as the internal inmemoryrenderer component's useEffect which sets the values
      // exectues before this outer, wrapping useEffect
      var existingRowKeyCount = Object.keys(_inMemoryValues.current).length;

      for (var i = rowCount; i < existingRowKeyCount; i++) {
        delete _inMemoryValues.current[i];
      }

      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, [inMemoryLevel, rowCount]);
  return [inMemoryValues, onCellRender];
}

function createKeyDownHandler(props, visibleColumns, leadingControlColumns, trailingControlColumns, focusedCell, headerIsInteractive, setFocusedCell, updateFocus) {
  return function (event) {
    if (focusedCell == null) return;
    var colCount = visibleColumns.length + leadingControlColumns.length + trailingControlColumns.length - 1;

    var _focusedCell = _slicedToArray(focusedCell, 2),
        x = _focusedCell[0],
        y = _focusedCell[1];

    var rowCount = computeVisibleRows(props);
    var key = event.key,
        ctrlKey = event.ctrlKey;

    if (key === _services.keys.ARROW_DOWN) {
      event.preventDefault();

      if (y < rowCount - 1) {
        setFocusedCell([x, y + 1]);
      }
    } else if (key === _services.keys.ARROW_LEFT) {
      event.preventDefault();

      if (x > 0) {
        setFocusedCell([x - 1, y]);
      }
    } else if (key === _services.keys.ARROW_UP) {
      event.preventDefault();
      var minimumIndex = headerIsInteractive ? -1 : 0;

      if (y > minimumIndex) {
        setFocusedCell([x, y - 1]);
      }
    } else if (key === _services.keys.ARROW_RIGHT) {
      event.preventDefault();

      if (x < colCount) {
        setFocusedCell([x + 1, y]);
      }
    } else if (key === _services.keys.PAGE_DOWN) {
      if (props.pagination) {
        event.preventDefault();
        var _rowCount = props.rowCount;
        var pageIndex = props.pagination.pageIndex;
        var pageSize = props.pagination.pageSize;
        var pageCount = Math.ceil(_rowCount / pageSize);

        if (pageIndex < pageCount - 1) {
          props.pagination.onChangePage(pageIndex + 1);
        }

        setFocusedCell([focusedCell[0], 0]);
        updateFocus();
      }
    } else if (key === _services.keys.PAGE_UP) {
      if (props.pagination) {
        event.preventDefault();
        var _pageIndex = props.pagination.pageIndex;

        if (_pageIndex > 0) {
          props.pagination.onChangePage(_pageIndex - 1);
        }

        setFocusedCell([focusedCell[0], props.pagination.pageSize - 1]);
        updateFocus();
      }
    } else if (key === (ctrlKey && _services.keys.END)) {
      event.preventDefault();
      setFocusedCell([colCount, rowCount - 1]);
    } else if (key === (ctrlKey && _services.keys.HOME)) {
      event.preventDefault();
      setFocusedCell([0, 0]);
    } else if (key === _services.keys.END) {
      event.preventDefault();
      setFocusedCell([colCount, y]);
    } else if (key === _services.keys.HOME) {
      event.preventDefault();
      setFocusedCell([0, y]);
    }
  };
}

function useAfterRender(fn) {
  var _useState7 = (0, _react.useState)(false),
      _useState8 = _slicedToArray(_useState7, 2),
      isSubscribed = _useState8[0],
      setIsSubscribed = _useState8[1];

  var _useState9 = (0, _react.useState)(false),
      _useState10 = _slicedToArray(_useState9, 2),
      needsExecution = _useState10[0],
      setNeedsExecution = _useState10[1]; // first useEffect waits for the parent & children to render & flush to dom


  (0, _react.useEffect)(function () {
    if (isSubscribed) {
      setIsSubscribed(false);
      setNeedsExecution(true);
    }
  }, [isSubscribed, setIsSubscribed, setNeedsExecution]); // second useEffect allows for a new `fn` to have been created
  // with any state updates before being called

  (0, _react.useEffect)(function () {
    if (needsExecution) {
      setNeedsExecution(false);
      fn();
    }
  }, [needsExecution, setNeedsExecution, fn]);
  return function () {
    setIsSubscribed(true);
  };
}

var useFocus = function useFocus(headerIsInteractive) {
  var _useState11 = (0, _react.useState)(undefined),
      _useState12 = _slicedToArray(_useState11, 2),
      focusedCell = _useState12[0],
      setFocusedCell = _useState12[1];

  var hasHadFocus = (0, _react.useMemo)(function () {
    return focusedCell != null;
  }, [focusedCell]);
  var focusProps = (0, _react.useMemo)(function () {
    return hasHadFocus ? {
      // FireFox allows tabbing to a div that is scrollable, while Chrome does not
      tabIndex: -1
    } : {
      tabIndex: 0,
      onFocus: function onFocus(e) {
        // if e.target (the source element of the `focus event`
        // matches e.currentTarget (always the div with this onFocus listener)
        // then the user has focused directly on the data grid wrapper (almost definitely by tabbing)
        // so shift focus to the first interactive cell within the grid
        if (e.target === e.currentTarget) {
          setFocusedCell(headerIsInteractive ? [0, -1] : [0, 0]);
        }
      }
    };
  }, [hasHadFocus, setFocusedCell, headerIsInteractive]);
  return [focusProps, focusedCell, setFocusedCell];
}; // Typeguards to see if toolbarVisibility has a certain boolean property assigned
// If not, just set it to true and assume it's OK to show


function objectHasKey(object, key) {
  return object.hasOwnProperty(key);
}

function checkOrDefaultToolBarDiplayOptions(arg, option) {
  if (arg === undefined) {
    return true;
  } else if (typeof arg === 'boolean') {
    return arg;
  } else if (objectHasKey(arg, option)) {
    return arg[option];
  } else {
    return true;
  }
}

var emptyArrayDefault = [];

var EuiDataGrid = function EuiDataGrid(props) {
  var _useState13 = (0, _react.useState)(false),
      _useState14 = _slicedToArray(_useState13, 2),
      isFullScreen = _useState14[0],
      setIsFullScreen = _useState14[1];

  var _useState15 = (0, _react.useState)(true),
      _useState16 = _slicedToArray(_useState15, 2),
      hasRoomForGridControls = _useState16[0],
      setHasRoomForGridControls = _useState16[1];

  var _useState17 = (0, _react.useState)(null),
      _useState18 = _slicedToArray(_useState17, 2),
      containerRef = _useState18[0],
      _setContainerRef = _useState18[1];

  var _useState19 = (0, _react.useState)((0, _services.htmlIdGenerator)()()),
      _useState20 = _slicedToArray(_useState19, 1),
      interactiveCellId = _useState20[0];

  var _useState21 = (0, _react.useState)(false),
      _useState22 = _slicedToArray(_useState21, 2),
      headerIsInteractive = _useState22[0],
      setHeaderIsInteractive = _useState22[1];

  var setContainerRef = (0, _react.useCallback)(function (ref) {
    return _setContainerRef(ref);
  }, []);

  var _useFocus = useFocus(headerIsInteractive),
      _useFocus2 = _slicedToArray(_useFocus, 3),
      wrappingDivFocusProps = _useFocus2[0],
      focusedCell = _useFocus2[1],
      setFocusedCell = _useFocus2[2];

  var handleHeaderChange = (0, _react.useCallback)(function (records) {
    var _records = _slicedToArray(records, 1),
        target = _records[0].target; // find the wrapping header div


    var headerRow = target.parentElement;

    while (headerRow && (headerRow.getAttribute('data-test-subj') || '').indexOf('dataGridHeader') === -1) {
      headerRow = headerRow.parentElement;
    }

    if (headerRow) {
      var tabbables = (0, _tabbable.default)(headerRow);
      var managed = headerRow.querySelectorAll('[data-euigrid-tab-managed]');
      var hasInteractives = tabbables.length > 0 || managed.length > 0;

      if (hasInteractives !== headerIsInteractive) {
        setHeaderIsInteractive(hasInteractives); // if the focus is on the header, and the header is no longer interactive
        // move the focus down to the first row

        if (hasInteractives === false && focusedCell && focusedCell[1] === -1) {
          setFocusedCell([focusedCell[0], 0]);
        }
      }
    }
  }, [headerIsInteractive, setHeaderIsInteractive, focusedCell, setFocusedCell]);

  var handleGridKeyDown = function handleGridKeyDown(event) {
    switch (event.key) {
      case _services.keys.ESCAPE:
        if (isFullScreen) {
          event.preventDefault();
          setIsFullScreen(false);
        }

        break;
    }
  };

  var _props$leadingControl = props.leadingControlColumns,
      leadingControlColumns = _props$leadingControl === void 0 ? emptyArrayDefault : _props$leadingControl,
      _props$trailingContro = props.trailingControlColumns,
      trailingControlColumns = _props$trailingContro === void 0 ? emptyArrayDefault : _props$trailingContro,
      columns = props.columns,
      columnVisibility = props.columnVisibility,
      schemaDetectors = props.schemaDetectors,
      rowCount = props.rowCount,
      renderCellValue = props.renderCellValue,
      className = props.className,
      gridStyle = props.gridStyle,
      _props$toolbarVisibil = props.toolbarVisibility,
      toolbarVisibility = _props$toolbarVisibil === void 0 ? true : _props$toolbarVisibil,
      pagination = props.pagination,
      sorting = props.sorting,
      inMemory = props.inMemory,
      popoverContents = props.popoverContents,
      onColumnResize = props.onColumnResize,
      _props$minSizeForCont = props.minSizeForControls,
      minSizeForControls = _props$minSizeForCont === void 0 ? MINIMUM_WIDTH_FOR_GRID_CONTROLS : _props$minSizeForCont,
      rest = _objectWithoutProperties(props, ["leadingControlColumns", "trailingControlColumns", "columns", "columnVisibility", "schemaDetectors", "rowCount", "renderCellValue", "className", "gridStyle", "toolbarVisibility", "pagination", "sorting", "inMemory", "popoverContents", "onColumnResize", "minSizeForControls"]); // enables/disables grid controls based on available width


  var onResize = useOnResize(function (nextHasRoomForGridControls) {
    if (nextHasRoomForGridControls !== hasRoomForGridControls) {
      setHasRoomForGridControls(nextHasRoomForGridControls);
    }
  }, isFullScreen, minSizeForControls);

  var _useColumnWidths = useColumnWidths(columns, onColumnResize),
      _useColumnWidths2 = _slicedToArray(_useColumnWidths, 2),
      columnWidths = _useColumnWidths2[0],
      setColumnWidth = _useColumnWidths2[1]; // apply style props on top of defaults


  var gridStyleWithDefaults = _objectSpread({}, _style_selector.startingStyles, {}, gridStyle);

  var _useInMemoryValues = useInMemoryValues(inMemory, rowCount),
      _useInMemoryValues2 = _slicedToArray(_useInMemoryValues, 2),
      inMemoryValues = _useInMemoryValues2[0],
      onCellRender = _useInMemoryValues2[1];

  var definedColumnSchemas = (0, _react.useMemo)(function () {
    return columns.reduce(function (definedColumnSchemas, _ref2) {
      var id = _ref2.id,
          schema = _ref2.schema;

      if (schema != null) {
        definedColumnSchemas[id] = schema;
      }

      return definedColumnSchemas;
    }, {});
  }, [columns]);
  var allSchemaDetectors = (0, _react.useMemo)(function () {
    return [].concat(_toConsumableArray(_data_grid_schema.schemaDetectors), _toConsumableArray(schemaDetectors || []));
  }, [schemaDetectors]);
  var detectedSchema = (0, _data_grid_schema.useDetectSchema)(inMemory, inMemoryValues, allSchemaDetectors, definedColumnSchemas, inMemory != null);
  var mergedSchema = (0, _data_grid_schema.useMergedSchema)(detectedSchema, columns);
  var displayValues = columns.reduce(function (acc, column) {
    return _objectSpread({}, acc, _defineProperty({}, column.id, column.displayAsText || column.id));
  }, {});

  var _useColumnSelector = (0, _column_selector.useColumnSelector)(columns, columnVisibility, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showColumnSelector'), displayValues),
      _useColumnSelector2 = _slicedToArray(_useColumnSelector, 2),
      columnSelector = _useColumnSelector2[0],
      orderedVisibleColumns = _useColumnSelector2[1];

  var columnSorting = (0, _column_sorting.useColumnSorting)(orderedVisibleColumns, sorting, mergedSchema, allSchemaDetectors, displayValues);

  var _useStyleSelector = (0, _style_selector.useStyleSelector)(gridStyleWithDefaults),
      _useStyleSelector2 = _slicedToArray(_useStyleSelector, 2),
      styleSelector = _useStyleSelector2[0],
      gridStyles = _useStyleSelector2[1]; // compute the default column width from the container's clientWidth and count of visible columns


  var defaultColumnWidth = useDefaultColumnWidth(containerRef, leadingControlColumns, trailingControlColumns, orderedVisibleColumns);
  var contentRef = (0, _react.useRef)(null); // Because of a weird Chrome bug with position:sticky css items and focus, we force scrolling to the top
  // if the item is in the first row. This prevents the cell from ever being under the sticky header.

  (0, _react.useEffect)(function () {
    if (focusedCell !== undefined && focusedCell[1] === 0) {
      if (contentRef.current != null) {
        contentRef.current.scrollTop = 0;
      }
    }
  }, [focusedCell]);
  var classes = (0, _classnames.default)('euiDataGrid', fontSizesToClassMap[gridStyles.fontSize], bordersToClassMap[gridStyles.border], headerToClassMap[gridStyles.header], rowHoverToClassMap[gridStyles.rowHover], cellPaddingsToClassMap[gridStyles.cellPadding], {
    'euiDataGrid--stripes': gridStyles.stripes
  }, {
    'euiDataGrid--fullScreen': isFullScreen
  }, {
    'euiDataGrid--noControls': !toolbarVisibility
  }, className);
  var controlBtnClasses = (0, _classnames.default)('euiDataGrid__controlBtn', {
    'euiDataGrid__controlBtn--active': isFullScreen
  }, className); // By default the toolbar appears

  var showToolbar = !!toolbarVisibility; // These grid controls will only show when there is room. Check the resize observer callback
  // They can also be optionally turned off individually by using toolbarVisibility

  var gridControls = _react.default.createElement(_react.Fragment, null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'additionalControls') && typeof toolbarVisibility !== 'boolean' ? toolbarVisibility.additionalControls : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showColumnSelector') ? columnSelector : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showStyleSelector') ? styleSelector : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showSortSelector') ? columnSorting : null); // When data grid is full screen, we add a class to the body to remove the extra scrollbar


  if (isFullScreen) {
    document.body.classList.add('euiDataGrid__restrictBody');
  } else {
    document.body.classList.remove('euiDataGrid__restrictBody');
  }

  var fullScreenSelector = _react.default.createElement(_i18n.EuiI18n, {
    tokens: ['euiDataGrid.fullScreenButton', 'euiDataGrid.fullScreenButtonActive'],
    defaults: ['Full screen', 'Exit full screen']
  }, function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        fullScreenButton = _ref4[0],
        fullScreenButtonActive = _ref4[1];

    return _react.default.createElement(_button.EuiButtonEmpty, {
      size: "xs",
      iconType: "fullScreen",
      color: "text",
      className: controlBtnClasses,
      "data-test-subj": "dataGridFullScrenButton",
      onClick: function onClick() {
        return setIsFullScreen(!isFullScreen);
      }
    }, isFullScreen ? fullScreenButtonActive : fullScreenButton);
  });

  var cellsUpdateFocus = (0, _react.useRef)(new Map());
  var focusAfterRender = useAfterRender(function () {
    if (focusedCell) {
      var _key = "".concat(focusedCell[0], "-").concat(focusedCell[1]);

      if (cellsUpdateFocus.current.has(_key)) {
        cellsUpdateFocus.current.get(_key)();
      }
    }
  });
  var datagridContext = (0, _react.useMemo)(function () {
    return {
      onFocusUpdate: function onFocusUpdate(cell, updateFocus) {
        if (pagination) {
          var _key2 = "".concat(cell[0], "-").concat(cell[1]);

          cellsUpdateFocus.current.set(_key2, updateFocus);
          return function () {
            cellsUpdateFocus.current.delete(_key2);
          };
        }
      }
    };
  }, [pagination]);
  var gridIds = (0, _services.htmlIdGenerator)();
  var gridId = gridIds();
  var ariaLabelledById = gridIds();
  return _react.default.createElement(_i18n.EuiI18n, {
    token: "euiDataGrid.ariaLabel",
    default: "{label}; Page {page} of {pageCount}.",
    values: {
      label: rest['aria-label'],
      page: pagination ? pagination.pageIndex + 1 : 0,
      pageCount: pagination ? Math.ceil(props.rowCount / pagination.pageSize) : 0
    }
  }, function (ariaLabel) {
    return _react.default.createElement(_i18n.EuiI18n, {
      token: "euiDataGrid.ariaLabelledBy",
      default: "Page {page} of {pageCount}.",
      values: {
        page: pagination ? pagination.pageIndex + 1 : 0,
        pageCount: pagination ? Math.ceil(props.rowCount / pagination.pageSize) : 0
      }
    }, function (ariaLabelledBy) {
      // extract aria-label and/or aria-labelledby from `rest`
      var gridAriaProps = {};

      if ('aria-label' in rest) {
        gridAriaProps['aria-label'] = pagination ? ariaLabel : rest['aria-label'];
        delete rest['aria-label'];
      }

      if ('aria-labelledby' in rest) {
        gridAriaProps['aria-labelledby'] = "".concat(rest['aria-labelledby'], " ").concat(pagination ? ariaLabelledById : '');
        delete rest['aria-labelledby'];
      }

      return _react.default.createElement(_data_grid_context.DataGridContext.Provider, {
        value: datagridContext
      }, _react.default.createElement(_focus_trap.EuiFocusTrap, {
        disabled: !isFullScreen,
        style: {
          height: '100%'
        }
      }, _react.default.createElement("div", {
        className: classes,
        onKeyDown: handleGridKeyDown,
        ref: setContainerRef
      }, (IS_JEST_ENVIRONMENT || defaultColumnWidth) && _react.default.createElement(_react.default.Fragment, null, showToolbar ? _react.default.createElement("div", {
        className: "euiDataGrid__controls",
        "data-test-sub": "dataGridControls"
      }, hasRoomForGridControls ? gridControls : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showFullScreenSelector') ? fullScreenSelector : null) : null, _react.default.createElement(_resize_observer.EuiResizeObserver, {
        onResize: onResize
      }, function (resizeRef) {
        return _react.default.createElement("div", _extends({
          onKeyDown: createKeyDownHandler(props, orderedVisibleColumns, leadingControlColumns, trailingControlColumns, focusedCell, headerIsInteractive, setFocusedCell, focusAfterRender),
          className: "euiDataGrid__verticalScroll",
          ref: resizeRef
        }, rest), _react.default.createElement("div", {
          className: "euiDataGrid__overflow"
        }, inMemory ? _react.default.createElement(_data_grid_inmemory_renderer.EuiDataGridInMemoryRenderer, {
          inMemory: inMemory,
          renderCellValue: renderCellValue,
          columns: columns,
          rowCount: inMemory.level === 'enhancements' ? // if `inMemory.level === enhancements` then we can only be sure the pagination's pageSize is available in memory
          pagination && pagination.pageSize || rowCount : // otherwise, all of the data is present and usable
          rowCount,
          onCellRender: onCellRender
        }) : null, _react.default.createElement("div", _extends({
          ref: contentRef,
          "data-test-subj": "dataGridWrapper",
          className: "euiDataGrid__content",
          role: "grid",
          id: gridId
        }, wrappingDivFocusProps, gridAriaProps), _react.default.createElement(_mutation_observer.EuiMutationObserver, {
          observerOptions: {
            subtree: true,
            childList: true
          },
          onMutation: handleHeaderChange
        }, function (ref) {
          return _react.default.createElement(_data_grid_header_row.EuiDataGridHeaderRow, {
            ref: ref,
            leadingControlColumns: leadingControlColumns,
            trailingControlColumns: trailingControlColumns,
            columns: orderedVisibleColumns,
            columnWidths: columnWidths,
            defaultColumnWidth: defaultColumnWidth,
            setColumnWidth: setColumnWidth,
            schema: mergedSchema,
            sorting: sorting,
            headerIsInteractive: headerIsInteractive,
            focusedCell: focusedCell,
            setFocusedCell: setFocusedCell
          });
        }), _react.default.createElement(_data_grid_body.EuiDataGridBody, {
          columnWidths: columnWidths,
          defaultColumnWidth: defaultColumnWidth,
          inMemoryValues: inMemoryValues,
          inMemory: inMemory,
          leadingControlColumns: leadingControlColumns,
          trailingControlColumns: trailingControlColumns,
          columns: orderedVisibleColumns,
          schema: mergedSchema,
          schemaDetectors: allSchemaDetectors,
          popoverContents: popoverContents,
          focusedCell: focusedCell,
          onCellFocus: setFocusedCell,
          pagination: pagination,
          sorting: sorting,
          renderCellValue: renderCellValue,
          rowCount: rowCount,
          interactiveCellId: interactiveCellId
        }))));
      }), props.pagination && props['aria-labelledby'] && _react.default.createElement("p", {
        id: ariaLabelledBy,
        hidden: true
      }, ariaLabelledBy), renderPagination(props, gridId), _react.default.createElement("p", {
        id: interactiveCellId,
        hidden: true
      }, _react.default.createElement(_i18n.EuiI18n, {
        token: "euiDataGrid.screenReaderNotice",
        default: "Cell contains interactive content."
      }))))));
    });
  });
};

exports.EuiDataGrid = EuiDataGrid;
EuiDataGrid.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiDataGrid"
};