"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
function withContext(ctx, fun) {
    ctx.save();
    fun(ctx);
    ctx.restore();
}
exports.withContext = withContext;
function clearCanvas(ctx, width, height) {
    withContext(ctx, function (ctx) {
        ctx.clearRect(-width, -height, 2 * width, 2 * height);
    });
}
exports.clearCanvas = clearCanvas;
function renderLayers(ctx, layers) {
    layers.forEach(function (renderLayer) { return renderLayer(ctx); });
}
exports.renderLayers = renderLayers;
function withClip(ctx, clipppings, fun, shouldClip) {
    if (shouldClip === void 0) { shouldClip = true; }
    withContext(ctx, function (ctx) {
        if (shouldClip) {
            var x = clipppings.x, y = clipppings.y, width = clipppings.width, height = clipppings.height;
            ctx.beginPath();
            ctx.rect(x, y, width, height);
            ctx.clip();
        }
        withContext(ctx, function (ctx) {
            fun(ctx);
        });
    });
}
exports.withClip = withClip;
function withClipRanges(ctx, clippedRanges, clippings, negate, fun) {
    if (negate === void 0) { negate = false; }
    withContext(ctx, function (ctx) {
        var length = clippedRanges.length;
        var width = clippings.width, height = clippings.height;
        ctx.beginPath();
        if (negate) {
            clippedRanges.forEach(function (_a) {
                var _b = __read(_a, 2), x0 = _b[0], x1 = _b[1];
                ctx.rect(x0, 0, x1 - x0, height);
            });
        }
        else {
            if (length > 0) {
                ctx.rect(0, 0, clippedRanges[0][0], height);
                var lastX = clippedRanges[length - 1][1];
                ctx.rect(lastX, 0, width - lastX, height);
            }
            if (length > 1) {
                for (var i = 1; i < length; i++) {
                    var _a = __read(clippedRanges[i - 1], 2), x0 = _a[1];
                    var _b = __read(clippedRanges[i], 1), x1 = _b[0];
                    ctx.rect(x0, 0, x1 - x0, height);
                }
            }
        }
        ctx.clip();
        fun(ctx);
    });
}
exports.withClipRanges = withClipRanges;
function withRotatedOrigin(ctx, origin, rotation, fn) {
    if (rotation === void 0) { rotation = 0; }
    withContext(ctx, function (ctx) {
        var x = origin.x, y = origin.y;
        ctx.translate(x, y);
        ctx.rotate((rotation * Math.PI) / 180);
        ctx.translate(-x, -y);
        fn(ctx);
    });
}
exports.withRotatedOrigin = withRotatedOrigin;
//# sourceMappingURL=index.js.map