/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class RangeMenu
extends JComboBox
implements ActionListener {
    private static final int[][] UNICODE_RANGES = RangeMenu.getUnicodeRanges();
    private static final String[] UNICODE_RANGE_NAMES = RangeMenu.getUnicodeRangeNames();
    private boolean useCustomRange = false;
    private int[] customRange = new int[]{0, 127};
    private final JDialog customRangeDialog;
    private final JTextField customRangeStart = new JTextField("0000", 4);
    private final JTextField customRangeEnd = new JTextField("007F", 4);
    private final int CUSTOM_RANGE_INDEX = UNICODE_RANGE_NAMES.length - 1;
    private final Font2DTest parent;
    public static final int SURROGATES_AREA_INDEX = 91;

    public RangeMenu(Font2DTest demo, JFrame f) {
        this.parent = demo;
        for (int i = 0; i < UNICODE_RANGE_NAMES.length; ++i) {
            this.addItem(UNICODE_RANGE_NAMES[i]);
        }
        this.setSelectedIndex(0);
        this.addActionListener(this);
        this.customRangeDialog = new JDialog(f, "Custom Unicode Range", true);
        this.customRangeDialog.setResizable(false);
        JPanel dialogTop = new JPanel();
        JPanel dialogBottom = new JPanel();
        JButton okButton = new JButton("OK");
        JLabel from = new JLabel("From:");
        JLabel to = new JLabel("To:");
        Font labelFont = new Font("dialog", 1, 12);
        from.setFont(labelFont);
        to.setFont(labelFont);
        okButton.setFont(labelFont);
        dialogTop.add(from);
        dialogTop.add(this.customRangeStart);
        dialogTop.add(to);
        dialogTop.add(this.customRangeEnd);
        dialogBottom.add(okButton);
        okButton.addActionListener(this);
        this.customRangeDialog.getContentPane().setLayout(new BorderLayout());
        this.customRangeDialog.getContentPane().add("North", dialogTop);
        this.customRangeDialog.getContentPane().add("South", dialogBottom);
        this.customRangeDialog.pack();
    }

    public int[] getSelectedRange() {
        if (this.useCustomRange) {
            int startIndex;
            int endIndex;
            String empty = "";
            try {
                String startText = this.customRangeStart.getText().trim();
                String endText = this.customRangeEnd.getText().trim();
                if (startText.equals(empty) && !endText.equals(empty)) {
                    endIndex = Integer.parseInt(endText, 16);
                    startIndex = endIndex - 175;
                } else if (!startText.equals(empty) && endText.equals(empty)) {
                    startIndex = Integer.parseInt(startText, 16);
                    endIndex = startIndex + 175;
                } else {
                    startIndex = Integer.parseInt(this.customRangeStart.getText(), 16);
                    endIndex = Integer.parseInt(this.customRangeEnd.getText(), 16);
                }
            }
            catch (Exception e) {
                this.customRangeStart.setText(Integer.toString(this.customRange[0], 16));
                this.customRangeEnd.setText(Integer.toString(this.customRange[1], 16));
                return this.customRange;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (endIndex > 65535) {
                endIndex = 65535;
            }
            if (startIndex > endIndex) {
                startIndex = endIndex;
            }
            this.customRange[0] = startIndex;
            this.customRange[1] = endIndex;
            return this.customRange;
        }
        return UNICODE_RANGES[this.getSelectedIndex()];
    }

    public void setSelectedRange(String name, int start, int end) {
        this.setSelectedItem(name);
        this.customRange[0] = start;
        this.customRange[1] = end;
        this.parent.fireRangeChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            String rangeName = (String)((JComboBox)source).getSelectedItem();
            if (rangeName.equals("Custom...")) {
                this.useCustomRange = true;
                this.customRangeDialog.setLocationRelativeTo(this.parent);
                this.customRangeDialog.show();
            } else {
                this.useCustomRange = false;
            }
            this.parent.fireRangeChanged();
        } else if (source instanceof JButton) {
            this.customRangeDialog.hide();
        }
    }

    private static int[][] getUnicodeRanges() {
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        ranges.add(0);
        Character.UnicodeBlock currentBlock = Character.UnicodeBlock.of(0);
        for (int cp = 1; cp < 0x110000; ++cp) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(cp);
            if (currentBlock == null) {
                if (ub == null) continue;
                ranges.add(cp);
                currentBlock = ub;
                continue;
            }
            if (ub == null) {
                ranges.add(cp - 1);
                currentBlock = null;
                continue;
            }
            if (cp == 0x10FFFF) {
                ranges.add(cp);
                continue;
            }
            if (ub.equals(currentBlock)) continue;
            ranges.add(cp - 1);
            ranges.add(cp);
            currentBlock = ub;
        }
        ranges.add(0);
        ranges.add(127);
        int[][] returnval = new int[ranges.size() / 2][2];
        for (int i = 0; i < ranges.size() / 2; ++i) {
            returnval[i][0] = (Integer)ranges.get(2 * i);
            returnval[i][1] = (Integer)ranges.get(2 * i + 1);
        }
        return returnval;
    }

    private static String[] getUnicodeRangeNames() {
        String[] names = new String[UNICODE_RANGES.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = RangeMenu.titleCase(Character.UnicodeBlock.of(UNICODE_RANGES[i][0]).toString());
        }
        names[names.length - 1] = "Custom...";
        return names;
    }

    private static String titleCase(String str) {
        str = str.replaceAll("_", " ");
        Pattern p = Pattern.compile("(^|\\W)([a-z])");
        Matcher m = p.matcher(str.toLowerCase(Locale.ROOT));
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + m.group(2).toUpperCase(Locale.ROOT));
        }
        m.appendTail(sb);
        return sb.toString().replace("Cjk", "CJK").replace("Nko", "NKo");
    }
}

