/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.Optional;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.internal.operations.ExecutingBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class DefaultTaskExecutionContext
implements TaskExecutionContext {
    private final LocalTaskNode localTaskNode;
    private TaskExecutionMode taskExecutionMode;
    private TaskProperties properties;
    private Long executionTime;
    private ExecutingBuildOperation snapshotTaskInputsBuildOperation;
    private final Timer executionTimer;

    public DefaultTaskExecutionContext(LocalTaskNode localTaskNode) {
        this.localTaskNode = localTaskNode;
        this.executionTimer = Time.startTimer();
    }

    @Override
    public LocalTaskNode getLocalTaskNode() {
        return this.localTaskNode;
    }

    @Override
    public TaskExecutionMode getTaskExecutionMode() {
        return this.taskExecutionMode;
    }

    @Override
    public void setTaskExecutionMode(TaskExecutionMode taskExecutionMode) {
        this.taskExecutionMode = taskExecutionMode;
    }

    @Override
    public long markExecutionTime() {
        if (this.executionTime != null) {
            throw new IllegalStateException("execution time already set");
        }
        this.executionTime = this.executionTimer.getElapsedMillis();
        return this.executionTime;
    }

    @Override
    public void setTaskProperties(TaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public TaskProperties getTaskProperties() {
        return this.properties;
    }

    @Override
    public Optional<ExecutingBuildOperation> removeSnapshotTaskInputsBuildOperation() {
        Optional<ExecutingBuildOperation> result = Optional.ofNullable(this.snapshotTaskInputsBuildOperation);
        this.snapshotTaskInputsBuildOperation = null;
        return result;
    }

    @Override
    public void setSnapshotTaskInputsBuildOperation(ExecutingBuildOperation snapshotTaskInputsBuildOperation) {
        this.snapshotTaskInputsBuildOperation = snapshotTaskInputsBuildOperation;
    }
}

