/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AStoreable;
import org.objectweb.asm.Type;

final class PSubDefField
extends AStoreable {
    private final String value;

    PSubDefField(Location location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.actual = this.expected == null || this.expected == ZonedDateTime.class || this.explicit ? def.class : this.expected;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        Type methodType = Type.getMethodType((Type)MethodWriter.getType(this.actual), (Type[])new Type[]{Type.getType(Object.class)});
        methodWriter.invokeDefCall(this.value, methodType, 1, new Object[0]);
    }

    @Override
    int accessElementCount() {
        return 1;
    }

    @Override
    boolean isDefOptimized() {
        return true;
    }

    @Override
    void updateActual(Class<?> actual) {
        this.actual = actual;
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        Type methodType = Type.getMethodType((Type)MethodWriter.getType(this.actual), (Type[])new Type[]{Type.getType(Object.class)});
        methodWriter.invokeDefCall(this.value, methodType, 1, new Object[0]);
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        Type methodType = Type.getMethodType((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), MethodWriter.getType(this.actual)});
        methodWriter.invokeDefCall(this.value, methodType, 2, new Object[0]);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.value);
    }
}

