/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BasicVector_ByteBuffer
extends AbstractVector {
    private int capacity;
    private ByteBuffer elements;
    private boolean directAllocation;

    public BasicVector_ByteBuffer(int capacity) {
        this(capacity, false);
    }

    public BasicVector_ByteBuffer(int capacity, boolean directAllocation) {
        this.directAllocation = directAllocation;
        this.elements = directAllocation ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.capacity = capacity;
    }

    public BasicVector_ByteBuffer(byte[] array, boolean directAllocation) {
        this.capacity = array.length;
        this.directAllocation = directAllocation;
        this.elements = ByteBuffer.wrap(array);
    }

    public BasicVector_ByteBuffer(LispObject[] array, boolean directAllocation) {
        this.directAllocation = directAllocation;
        this.capacity = array.length;
        this.elements = directAllocation ? ByteBuffer.allocateDirect(array.length) : ByteBuffer.allocate(array.length);
        int i = array.length;
        while (i-- > 0) {
            this.elements.put(Lisp.coerceLispObjectToJavaByte(array[i]));
        }
    }

    public BasicVector_ByteBuffer(ByteBuffer buffer, boolean directAllocation) {
        this.elements = buffer;
        this.directAllocation = directAllocation;
        this.capacity = buffer.limit();
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, Lisp.UNSIGNED_BYTE_8, new Cons(Fixnum.getInstance(this.capacity)));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_8;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        try {
            return Lisp.coerceJavaByteToLispObject(this.elements.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public int aref(int index) {
        try {
            return this.elements.get(index) & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return 0;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return Lisp.coerceJavaByteToLispObject(this.elements.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.limit());
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, int n) {
        try {
            this.elements.put(index, (byte)n);
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public void aset(int index, LispObject value) {
        try {
            this.elements.put(index, Lisp.coerceLispObjectToJavaByte(value));
        }
        catch (IndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        BasicVector_ByteBuffer v = new BasicVector_ByteBuffer(end - start, this.directAllocation);
        ByteBuffer view = this.elements.asReadOnlyBuffer();
        view.position(start);
        view.limit(end);
        try {
            v.elements.put(view);
            return v;
        }
        catch (BufferOverflowException e) {
            return Lisp.error(new TypeError("Could not form a subseq from " + start + " to " + end));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof Fixnum)) {
            Lisp.type_error(obj, Symbol.FIXNUM);
            return;
        }
        int n = ((Fixnum)obj).value;
        if (n < 0 || n > 255) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_8);
            return;
        }
        int i = this.length();
        while (i-- > 0) {
            this.elements.put(i, (byte)n);
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.length()) {
            this.elements.limit(n);
            this.capacity = n;
            return;
        }
        if (n == this.length()) {
            return;
        }
        Lisp.error(new LispError("Attempted to shrink an array to a size greater than its capacity"));
    }

    @Override
    public LispObject reverse() {
        BasicVector_ByteBuffer result = new BasicVector_ByteBuffer(this.length(), this.directAllocation);
        int i = 0;
        int j = this.length() - 1;
        while (i < this.length()) {
            result.elements.put(i, this.elements.get(j));
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity() - 1; i < j; ++i, --j) {
            byte temp = this.elements.get(i);
            this.elements.put(i, this.elements.get(j));
            this.elements.put(j, temp);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            ByteBuffer newElements = this.directAllocation ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements.put(i, Lisp.coerceLispObjectToJavaByte(list.car()));
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements.put(i, Lisp.coerceLispObjectToJavaByte(initialContents.elt(i)));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new BasicVector_ByteBuffer(newElements, this.directAllocation);
        }
        if (this.length() != newCapacity) {
            int i;
            ByteBuffer newElements = this.directAllocation ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
            if (this.elements.hasArray()) {
                newElements.put(this.elements.array(), 0, Math.min(this.length(), newCapacity));
            } else {
                int limit = Math.min(this.length(), newCapacity);
                for (i = 0; i < limit; ++i) {
                    newElements.put(i, this.elements.get(i));
                }
            }
            if (initialElement != null) {
                byte initValue = (byte)(initialElement.intValue() & 0xFF);
                for (i = this.length(); i < newCapacity; ++i) {
                    newElements.put(i, initValue);
                }
            }
            return new BasicVector_ByteBuffer(newElements, this.directAllocation);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }
}

