/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet.imagereview;

import com.thaiopensource.validate.Validator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import nu.validator.checker.AttributeUtil;
import nu.validator.servlet.imagereview.Image;
import nu.validator.source.SourceCode;
import nu.validator.xml.UriLangContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ImageCollector
implements Validator,
ContentHandler,
Iterable<Image> {
    private final SourceCode sourceCode;
    private final List<Image> images = new LinkedList<Image>();
    private UriLangContext context = null;
    private int depthInLink = 0;
    private Locator locator = null;

    public ImageCollector(SourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void initializeContext(UriLangContext c) {
        this.context = c;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.depthInLink > 0) {
            --this.depthInLink;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.depthInLink > 0) {
            ++this.depthInLink;
        } else if ("http://www.w3.org/1999/xhtml" == uri && "a" == name) {
            this.depthInLink = 1;
            return;
        }
        if ("http://www.w3.org/1999/xhtml" == uri && "img" == name) {
            String alt = null;
            String src = null;
            int width = -1;
            int height = -1;
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                if ("" != atts.getURI(i)) continue;
                String n = atts.getLocalName(i);
                if ("src" == n) {
                    src = this.context.toAbsoluteUriWithCurrentBase(atts.getValue(i));
                    continue;
                }
                if ("alt" == n) {
                    alt = atts.getValue(i);
                    continue;
                }
                if ("width" == n) {
                    width = AttributeUtil.parsePositiveInteger(atts.getValue(i));
                    continue;
                }
                if ("height" != n) continue;
                height = AttributeUtil.parsePositiveInteger(atts.getValue(i));
            }
            Image image = new Image(src, alt, this.context.currentLanguage(), this.context.isCurrentRtl(), width, height, this.depthInLink > 0, this.locator);
            this.sourceCode.registerRandeEnd(image);
            this.images.add(image);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public Iterator<Image> iterator() {
        return this.images.iterator();
    }

    public boolean isEmpty() {
        return this.images.isEmpty();
    }
}

