/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decoder
extends ChannelInboundHandlerAdapter {
    protected static final int DEFAULT_MAX_COMPOSITE_BUFFER_COMPONENTS = 1024;
    private ByteBuf cumulation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        if (message instanceof ByteBuf) {
            ByteBuf input = (ByteBuf)message;
            try {
                this.messageReceived(context, input);
            }
            finally {
                if (input.refCnt() > 0) {
                    input.release();
                }
            }
        } else {
            context.fireChannelRead(message);
        }
    }

    protected abstract void messageReceived(@NotNull ChannelHandlerContext var1, @NotNull ByteBuf var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <T> T readContent(@NotNull ByteBuf input, @NotNull ChannelHandlerContext context, int contentLength, @NotNull FullMessageConsumer<T> fullMessageConsumer) throws IOException {
        ByteBuf buffer;
        if (input == null) {
            Decoder.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Decoder.$$$reportNull$$$0(1);
        }
        if (fullMessageConsumer == null) {
            Decoder.$$$reportNull$$$0(2);
        }
        if ((buffer = this.getBufferIfSufficient(input, contentLength, context)) == null) {
            return null;
        }
        boolean isCumulateBuffer = buffer != input;
        int oldReaderIndex = input.readerIndex();
        try {
            T t = fullMessageConsumer.contentReceived(buffer, context, isCumulateBuffer);
            return t;
        }
        finally {
            if (isCumulateBuffer) {
                buffer.release();
            } else {
                buffer.readerIndex(oldReaderIndex + contentLength);
            }
        }
    }

    @Nullable
    protected final ByteBuf getBufferIfSufficient(@NotNull ByteBuf input, int requiredLength, @NotNull ChannelHandlerContext context) {
        CompositeByteBuf buffer;
        if (input == null) {
            Decoder.$$$reportNull$$$0(3);
        }
        if (context == null) {
            Decoder.$$$reportNull$$$0(4);
        }
        if (!input.isReadable()) {
            return null;
        }
        if (this.cumulation == null) {
            if (input.readableBytes() < requiredLength) {
                this.cumulation = input;
                input.retain();
                input.touch();
                return null;
            }
            return input;
        }
        int currentAccumulatedByteCount = this.cumulation.readableBytes();
        if (currentAccumulatedByteCount + input.readableBytes() < requiredLength) {
            CompositeByteBuf compositeByteBuf;
            if (this.cumulation instanceof CompositeByteBuf) {
                compositeByteBuf = (CompositeByteBuf)this.cumulation;
            } else {
                compositeByteBuf = context.alloc().compositeBuffer(1024);
                compositeByteBuf.addComponent(true, this.cumulation);
                this.cumulation = compositeByteBuf;
            }
            compositeByteBuf.addComponent(true, input);
            input.retain();
            input.touch();
            return null;
        }
        if (this.cumulation instanceof CompositeByteBuf) {
            buffer = (CompositeByteBuf)this.cumulation;
            buffer.addComponent(input);
        } else {
            buffer = context.alloc().compositeBuffer(1024);
            buffer.addComponents(new ByteBuf[]{this.cumulation, input});
        }
        buffer.writerIndex(requiredLength);
        input.skipBytes(requiredLength - currentAccumulatedByteCount);
        input.retain();
        input.touch();
        this.cumulation = null;
        return buffer;
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        try {
            if (this.cumulation != null) {
                this.cumulation.release();
                this.cumulation = null;
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessageConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/Decoder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getBufferIfSufficient";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FullMessageConsumer<T> {
        public T contentReceived(@NotNull ByteBuf var1, @NotNull ChannelHandlerContext var2, boolean var3) throws IOException;
    }
}

